@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Log policy schedule.
 * @property scheduleFrequencyInMins Frequency of the log schedule operation of this policy in minutes.
 * @property schedulePolicyType This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
 * Expected value is 'LogSchedulePolicy'.
 */
public data class LogSchedulePolicyResponse(
    public val scheduleFrequencyInMins: Int? = null,
    public val schedulePolicyType: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.recoveryservices.outputs.LogSchedulePolicyResponse): LogSchedulePolicyResponse = LogSchedulePolicyResponse(
            scheduleFrequencyInMins = javaType.scheduleFrequencyInMins().map({ args0 -> args0 }).orElse(null),
            schedulePolicyType = javaType.schedulePolicyType(),
        )
    }
}
