@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * MAB workload-specific Health Details.
 * @property code Health Code
 * @property message Health Message
 * @property recommendations Health Recommended Actions
 * @property title Health Title
 */
public data class MABContainerHealthDetailsResponse(
    public val code: Int? = null,
    public val message: String? = null,
    public val recommendations: List<String>? = null,
    public val title: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.recoveryservices.outputs.MABContainerHealthDetailsResponse): MABContainerHealthDetailsResponse = MABContainerHealthDetailsResponse(
            code = javaType.code().map({ args0 -> args0 }).orElse(null),
            message = javaType.message().map({ args0 -> args0 }).orElse(null),
            recommendations = javaType.recommendations().map({ args0 -> args0 }),
            title = javaType.title().map({ args0 -> args0 }).orElse(null),
        )
    }
}
