@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Additional information of the container.
 * @property backupItemType Type of backup items associated with this container.
 * @property backupItems List of backup items associated with this container.
 * @property lastBackupStatus Latest backup status of this container.
 * @property lastRefreshedAt Time stamp when this container was refreshed.
 * @property policyName Backup policy associated with this container.
 */
public data class MabContainerExtendedInfoResponse(
    public val backupItemType: String? = null,
    public val backupItems: List<String>? = null,
    public val lastBackupStatus: String? = null,
    public val lastRefreshedAt: String? = null,
    public val policyName: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.recoveryservices.outputs.MabContainerExtendedInfoResponse): MabContainerExtendedInfoResponse = MabContainerExtendedInfoResponse(
            backupItemType = javaType.backupItemType().map({ args0 -> args0 }).orElse(null),
            backupItems = javaType.backupItems().map({ args0 -> args0 }),
            lastBackupStatus = javaType.lastBackupStatus().map({ args0 -> args0 }).orElse(null),
            lastRefreshedAt = javaType.lastRefreshedAt().map({ args0 -> args0 }).orElse(null),
            policyName = javaType.policyName().map({ args0 -> args0 }).orElse(null),
        )
    }
}
