@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Additional information on the backed up item.
 * @property lastRefreshedAt Last time when the agent data synced to service.
 * @property oldestRecoveryPoint The oldest backup copy available.
 * @property recoveryPointCount Number of backup copies associated with the backup item.
 */
public data class MabFileFolderProtectedItemExtendedInfoResponse(
    public val lastRefreshedAt: String? = null,
    public val oldestRecoveryPoint: String? = null,
    public val recoveryPointCount: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.recoveryservices.outputs.MabFileFolderProtectedItemExtendedInfoResponse): MabFileFolderProtectedItemExtendedInfoResponse =
            MabFileFolderProtectedItemExtendedInfoResponse(
                lastRefreshedAt = javaType.lastRefreshedAt().map({ args0 -> args0 }).orElse(null),
                oldestRecoveryPoint = javaType.oldestRecoveryPoint().map({ args0 -> args0 }).orElse(null),
                recoveryPointCount = javaType.recoveryPointCount().map({ args0 -> args0 }).orElse(null),
            )
    }
}
