@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.outputs

import com.pulumi.core.Either
import kotlin.Any
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Mab container-specific backup policy.
 * @property backupManagementType This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
 * Expected value is 'MAB'.
 * @property protectedItemsCount Number of items associated with this policy.
 * @property resourceGuardOperationRequests ResourceGuard Operation Requests
 * @property retentionPolicy Retention policy details.
 * @property schedulePolicy Backup schedule of backup policy.
 */
public data class MabProtectionPolicyResponse(
    public val backupManagementType: String,
    public val protectedItemsCount: Int? = null,
    public val resourceGuardOperationRequests: List<String>? = null,
    public val retentionPolicy: Either<LongTermRetentionPolicyResponse, SimpleRetentionPolicyResponse>? = null,
    public val schedulePolicy: Any? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.recoveryservices.outputs.MabProtectionPolicyResponse): MabProtectionPolicyResponse = MabProtectionPolicyResponse(
            backupManagementType = javaType.backupManagementType(),
            protectedItemsCount = javaType.protectedItemsCount().map({ args0 -> args0 }).orElse(null),
            resourceGuardOperationRequests = javaType.resourceGuardOperationRequests().map({ args0 -> args0 }),
            retentionPolicy = javaType.retentionPolicy().map({ args0 ->
                args0.transform(
                    { args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.recoveryservices.kotlin.outputs.LongTermRetentionPolicyResponse.Companion.toKotlin(args0)
                        })
                    },
                    { args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.recoveryservices.kotlin.outputs.SimpleRetentionPolicyResponse.Companion.toKotlin(args0)
                        })
                    },
                )
            }).orElse(null),
            schedulePolicy = javaType.schedulePolicy().map({ args0 -> args0 }).orElse(null),
        )
    }
}
