@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Details of a Master Target Server.
 * @property agentExpiryDate Agent expiry date.
 * @property agentVersion The version of the scout component on the server.
 * @property agentVersionDetails Agent version details.
 * @property dataStores The list of data stores in the fabric.
 * @property diskCount Disk count of the master target.
 * @property healthErrors Health errors.
 * @property id The server Id.
 * @property ipAddress The IP address of the server.
 * @property lastHeartbeat The last heartbeat received from the server.
 * @property marsAgentExpiryDate MARS agent expiry date.
 * @property marsAgentVersion MARS agent version.
 * @property marsAgentVersionDetails Mars agent version details.
 * @property name The server name.
 * @property osType The OS type of the server.
 * @property osVersion OS Version of the master target.
 * @property retentionVolumes The retention volumes of Master target Server.
 * @property validationErrors Validation errors.
 * @property versionStatus Version status.
 */
public data class MasterTargetServerResponse(
    public val agentExpiryDate: String? = null,
    public val agentVersion: String? = null,
    public val agentVersionDetails: VersionDetailsResponse? = null,
    public val dataStores: List<DataStoreResponse>? = null,
    public val diskCount: Int? = null,
    public val healthErrors: List<HealthErrorResponse>? = null,
    public val id: String? = null,
    public val ipAddress: String? = null,
    public val lastHeartbeat: String? = null,
    public val marsAgentExpiryDate: String? = null,
    public val marsAgentVersion: String? = null,
    public val marsAgentVersionDetails: VersionDetailsResponse? = null,
    public val name: String? = null,
    public val osType: String? = null,
    public val osVersion: String? = null,
    public val retentionVolumes: List<RetentionVolumeResponse>? = null,
    public val validationErrors: List<HealthErrorResponse>? = null,
    public val versionStatus: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.recoveryservices.outputs.MasterTargetServerResponse): MasterTargetServerResponse = MasterTargetServerResponse(
            agentExpiryDate = javaType.agentExpiryDate().map({ args0 -> args0 }).orElse(null),
            agentVersion = javaType.agentVersion().map({ args0 -> args0 }).orElse(null),
            agentVersionDetails = javaType.agentVersionDetails().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.recoveryservices.kotlin.outputs.VersionDetailsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            dataStores = javaType.dataStores().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.recoveryservices.kotlin.outputs.DataStoreResponse.Companion.toKotlin(args0)
                })
            }),
            diskCount = javaType.diskCount().map({ args0 -> args0 }).orElse(null),
            healthErrors = javaType.healthErrors().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.recoveryservices.kotlin.outputs.HealthErrorResponse.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            ipAddress = javaType.ipAddress().map({ args0 -> args0 }).orElse(null),
            lastHeartbeat = javaType.lastHeartbeat().map({ args0 -> args0 }).orElse(null),
            marsAgentExpiryDate = javaType.marsAgentExpiryDate().map({ args0 -> args0 }).orElse(null),
            marsAgentVersion = javaType.marsAgentVersion().map({ args0 -> args0 }).orElse(null),
            marsAgentVersionDetails = javaType.marsAgentVersionDetails().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.recoveryservices.kotlin.outputs.VersionDetailsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            osType = javaType.osType().map({ args0 -> args0 }).orElse(null),
            osVersion = javaType.osVersion().map({ args0 -> args0 }).orElse(null),
            retentionVolumes = javaType.retentionVolumes().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.recoveryservices.kotlin.outputs.RetentionVolumeResponse.Companion.toKotlin(args0)
                })
            }),
            validationErrors = javaType.validationErrors().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.recoveryservices.kotlin.outputs.HealthErrorResponse.Companion.toKotlin(args0)
                })
            }),
            versionStatus = javaType.versionStatus().map({ args0 -> args0 }).orElse(null),
        )
    }
}
