@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Migration item properties.
 * @property allowedOperations The allowed operations on the migration item based on the current migration state of the item.
 * @property criticalJobHistory The critical past job details.
 * @property currentJob The current job details.
 * @property eventCorrelationId The correlation Id for events associated with this migration item.
 * @property health The consolidated health.
 * @property healthErrors The list of health errors.
 * @property lastMigrationStatus The status of the last migration.
 * @property lastMigrationTime The last migration time.
 * @property lastTestMigrationStatus The status of the last test migration.
 * @property lastTestMigrationTime The last test migration time.
 * @property machineName The on-premise virtual machine name.
 * @property migrationState The migration status.
 * @property migrationStateDescription The migration state description.
 * @property policyFriendlyName The name of policy governing this item.
 * @property policyId The ARM Id of policy governing this item.
 * @property providerSpecificDetails The migration provider custom settings.
 * @property recoveryServicesProviderId The recovery services provider ARM Id.
 * @property replicationStatus The replication status.
 * @property testMigrateState The test migrate state.
 * @property testMigrateStateDescription The test migrate state description.
 */
public data class MigrationItemPropertiesResponse(
    public val allowedOperations: List<String>,
    public val criticalJobHistory: List<CriticalJobHistoryDetailsResponse>,
    public val currentJob: CurrentJobDetailsResponse,
    public val eventCorrelationId: String,
    public val health: String,
    public val healthErrors: List<HealthErrorResponse>,
    public val lastMigrationStatus: String,
    public val lastMigrationTime: String,
    public val lastTestMigrationStatus: String,
    public val lastTestMigrationTime: String,
    public val machineName: String,
    public val migrationState: String,
    public val migrationStateDescription: String,
    public val policyFriendlyName: String,
    public val policyId: String,
    public val providerSpecificDetails: VMwareCbtMigrationDetailsResponse? = null,
    public val recoveryServicesProviderId: String,
    public val replicationStatus: String,
    public val testMigrateState: String,
    public val testMigrateStateDescription: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.recoveryservices.outputs.MigrationItemPropertiesResponse): MigrationItemPropertiesResponse = MigrationItemPropertiesResponse(
            allowedOperations = javaType.allowedOperations().map({ args0 -> args0 }),
            criticalJobHistory = javaType.criticalJobHistory().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.recoveryservices.kotlin.outputs.CriticalJobHistoryDetailsResponse.Companion.toKotlin(args0)
                })
            }),
            currentJob = javaType.currentJob().let({ args0 ->
                com.pulumi.azurenative.recoveryservices.kotlin.outputs.CurrentJobDetailsResponse.Companion.toKotlin(args0)
            }),
            eventCorrelationId = javaType.eventCorrelationId(),
            health = javaType.health(),
            healthErrors = javaType.healthErrors().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.recoveryservices.kotlin.outputs.HealthErrorResponse.Companion.toKotlin(args0)
                })
            }),
            lastMigrationStatus = javaType.lastMigrationStatus(),
            lastMigrationTime = javaType.lastMigrationTime(),
            lastTestMigrationStatus = javaType.lastTestMigrationStatus(),
            lastTestMigrationTime = javaType.lastTestMigrationTime(),
            machineName = javaType.machineName(),
            migrationState = javaType.migrationState(),
            migrationStateDescription = javaType.migrationStateDescription(),
            policyFriendlyName = javaType.policyFriendlyName(),
            policyId = javaType.policyId(),
            providerSpecificDetails = javaType.providerSpecificDetails().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.recoveryservices.kotlin.outputs.VMwareCbtMigrationDetailsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            recoveryServicesProviderId = javaType.recoveryServicesProviderId(),
            replicationStatus = javaType.replicationStatus(),
            testMigrateState = javaType.testMigrateState(),
            testMigrateStateDescription = javaType.testMigrateStateDescription(),
        )
    }
}
