@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The Mobility Service update details.
 * @property osType The OS type.
 * @property rebootStatus The reboot status of the update - whether it is required or not.
 * @property version The version of the latest update.
 */
public data class MobilityServiceUpdateResponse(
    public val osType: String? = null,
    public val rebootStatus: String? = null,
    public val version: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.recoveryservices.outputs.MobilityServiceUpdateResponse): MobilityServiceUpdateResponse = MobilityServiceUpdateResponse(
            osType = javaType.osType().map({ args0 -> args0 }).orElse(null),
            rebootStatus = javaType.rebootStatus().map({ args0 -> args0 }).orElse(null),
            version = javaType.version().map({ args0 -> args0 }).orElse(null),
        )
    }
}
