@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.outputs

import kotlin.Suppress

/**
 * Monitoring Settings of the vault
 * @property azureMonitorAlertSettings Settings for Azure Monitor based alerts
 * @property classicAlertSettings Settings for classic alerts
 */
public data class MonitoringSettingsResponse(
    public val azureMonitorAlertSettings: AzureMonitorAlertSettingsResponse? = null,
    public val classicAlertSettings: ClassicAlertSettingsResponse? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.recoveryservices.outputs.MonitoringSettingsResponse): MonitoringSettingsResponse = MonitoringSettingsResponse(
            azureMonitorAlertSettings = javaType.azureMonitorAlertSettings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.recoveryservices.kotlin.outputs.AzureMonitorAlertSettingsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            classicAlertSettings = javaType.classicAlertSettings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.recoveryservices.kotlin.outputs.ClassicAlertSettingsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
