@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Details of the OS Disk.
 * @property osType The type of the OS on the VM.
 * @property osVhdId The id of the disk containing the OS.
 * @property vhdName The OS disk VHD name.
 */
public data class OSDiskDetailsResponse(
    public val osType: String? = null,
    public val osVhdId: String? = null,
    public val vhdName: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.recoveryservices.outputs.OSDiskDetailsResponse): OSDiskDetailsResponse = OSDiskDetailsResponse(
            osType = javaType.osType().map({ args0 -> args0 }).orElse(null),
            osVhdId = javaType.osVhdId().map({ args0 -> args0 }).orElse(null),
            vhdName = javaType.vhdName().map({ args0 -> args0 }).orElse(null),
        )
    }
}
