@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress

/**
 * Protection profile custom data details.
 * @property friendlyName The FriendlyName.
 * @property providerSpecificDetails The ReplicationChannelSetting.
 */
public data class PolicyPropertiesResponse(
    public val friendlyName: String? = null,
    public val providerSpecificDetails: Any? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.recoveryservices.outputs.PolicyPropertiesResponse): PolicyPropertiesResponse = PolicyPropertiesResponse(
            friendlyName = javaType.friendlyName().map({ args0 -> args0 }).orElse(null),
            providerSpecificDetails = javaType.providerSpecificDetails().map({ args0 -> args0 }).orElse(null),
        )
    }
}
