@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Information to be stored in Vault properties as an element of privateEndpointConnections List.
 * @property id Format of id subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.[Service]/{resource}/{resourceName}/privateEndpointConnections/{connectionName}.
 * @property location The location of the private Endpoint connection
 * @property name The name of the private Endpoint Connection
 * @property properties Private Endpoint Connection Response Properties.
 * @property type The type, which will be of the format, Microsoft.RecoveryServices/vaults/privateEndpointConnections
 */
public data class PrivateEndpointConnectionVaultPropertiesResponse(
    public val id: String,
    public val location: String,
    public val name: String,
    public val properties: VaultPrivateEndpointConnectionResponse,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.recoveryservices.outputs.PrivateEndpointConnectionVaultPropertiesResponse): PrivateEndpointConnectionVaultPropertiesResponse =
            PrivateEndpointConnectionVaultPropertiesResponse(
                id = javaType.id(),
                location = javaType.location(),
                name = javaType.name(),
                properties = javaType.properties().let({ args0 ->
                    com.pulumi.azurenative.recoveryservices.kotlin.outputs.VaultPrivateEndpointConnectionResponse.Companion.toKotlin(args0)
                }),
                type = javaType.type(),
            )
    }
}
