@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.outputs

import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Details of the Process Server.
 * @property agentExpiryDate Agent expiry date.
 * @property agentVersion The version of the scout component on the server.
 * @property agentVersionDetails The agent version details.
 * @property availableMemoryInBytes The available memory.
 * @property availableSpaceInBytes The available space.
 * @property cpuLoad The percentage of the CPU load.
 * @property cpuLoadStatus The CPU load status.
 * @property friendlyName The Process Server's friendly name.
 * @property health The health of Process Server.
 * @property healthErrors Health errors.
 * @property hostId The agent generated Id.
 * @property id The Process Server Id.
 * @property ipAddress The IP address of the server.
 * @property lastHeartbeat The last heartbeat received from the server.
 * @property machineCount The servers configured with this PS.
 * @property marsCommunicationStatus The MARS communication status.
 * @property marsRegistrationStatus The MARS registration status.
 * @property memoryUsageStatus The memory usage status.
 * @property mobilityServiceUpdates The list of the mobility service updates available on the Process Server.
 * @property osType The OS type of the server.
 * @property osVersion OS Version of the process server. Note: This will get populated if user has CS version greater than 9.12.0.0.
 * @property psServiceStatus The PS service status.
 * @property psStatsRefreshTime The process server stats refresh time.
 * @property replicationPairCount The number of replication pairs configured in this PS.
 * @property spaceUsageStatus The space usage status.
 * @property sslCertExpiryDate The PS SSL cert expiry date.
 * @property sslCertExpiryRemainingDays CS SSL cert expiry date.
 * @property systemLoad The percentage of the system load.
 * @property systemLoadStatus The system load status.
 * @property throughputInBytes The throughput in bytes.
 * @property throughputInMBps The throughput in MBps.
 * @property throughputStatus The throughput status.
 * @property throughputUploadPendingDataInBytes The uploading pending data in bytes.
 * @property totalMemoryInBytes The total memory.
 * @property totalSpaceInBytes The total space.
 * @property versionStatus Version status.
 */
public data class ProcessServerResponse(
    public val agentExpiryDate: String? = null,
    public val agentVersion: String? = null,
    public val agentVersionDetails: VersionDetailsResponse? = null,
    public val availableMemoryInBytes: Double? = null,
    public val availableSpaceInBytes: Double? = null,
    public val cpuLoad: String? = null,
    public val cpuLoadStatus: String? = null,
    public val friendlyName: String? = null,
    public val health: String,
    public val healthErrors: List<HealthErrorResponse>? = null,
    public val hostId: String? = null,
    public val id: String? = null,
    public val ipAddress: String? = null,
    public val lastHeartbeat: String? = null,
    public val machineCount: String? = null,
    public val marsCommunicationStatus: String,
    public val marsRegistrationStatus: String,
    public val memoryUsageStatus: String? = null,
    public val mobilityServiceUpdates: List<MobilityServiceUpdateResponse>? = null,
    public val osType: String? = null,
    public val osVersion: String? = null,
    public val psServiceStatus: String? = null,
    public val psStatsRefreshTime: String,
    public val replicationPairCount: String? = null,
    public val spaceUsageStatus: String? = null,
    public val sslCertExpiryDate: String? = null,
    public val sslCertExpiryRemainingDays: Int? = null,
    public val systemLoad: String? = null,
    public val systemLoadStatus: String? = null,
    public val throughputInBytes: Double,
    public val throughputInMBps: Double,
    public val throughputStatus: String,
    public val throughputUploadPendingDataInBytes: Double,
    public val totalMemoryInBytes: Double? = null,
    public val totalSpaceInBytes: Double? = null,
    public val versionStatus: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.recoveryservices.outputs.ProcessServerResponse): ProcessServerResponse = ProcessServerResponse(
            agentExpiryDate = javaType.agentExpiryDate().map({ args0 -> args0 }).orElse(null),
            agentVersion = javaType.agentVersion().map({ args0 -> args0 }).orElse(null),
            agentVersionDetails = javaType.agentVersionDetails().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.recoveryservices.kotlin.outputs.VersionDetailsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            availableMemoryInBytes = javaType.availableMemoryInBytes().map({ args0 -> args0 }).orElse(null),
            availableSpaceInBytes = javaType.availableSpaceInBytes().map({ args0 -> args0 }).orElse(null),
            cpuLoad = javaType.cpuLoad().map({ args0 -> args0 }).orElse(null),
            cpuLoadStatus = javaType.cpuLoadStatus().map({ args0 -> args0 }).orElse(null),
            friendlyName = javaType.friendlyName().map({ args0 -> args0 }).orElse(null),
            health = javaType.health(),
            healthErrors = javaType.healthErrors().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.recoveryservices.kotlin.outputs.HealthErrorResponse.Companion.toKotlin(args0)
                })
            }),
            hostId = javaType.hostId().map({ args0 -> args0 }).orElse(null),
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            ipAddress = javaType.ipAddress().map({ args0 -> args0 }).orElse(null),
            lastHeartbeat = javaType.lastHeartbeat().map({ args0 -> args0 }).orElse(null),
            machineCount = javaType.machineCount().map({ args0 -> args0 }).orElse(null),
            marsCommunicationStatus = javaType.marsCommunicationStatus(),
            marsRegistrationStatus = javaType.marsRegistrationStatus(),
            memoryUsageStatus = javaType.memoryUsageStatus().map({ args0 -> args0 }).orElse(null),
            mobilityServiceUpdates = javaType.mobilityServiceUpdates().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.recoveryservices.kotlin.outputs.MobilityServiceUpdateResponse.Companion.toKotlin(args0)
                })
            }),
            osType = javaType.osType().map({ args0 -> args0 }).orElse(null),
            osVersion = javaType.osVersion().map({ args0 -> args0 }).orElse(null),
            psServiceStatus = javaType.psServiceStatus().map({ args0 -> args0 }).orElse(null),
            psStatsRefreshTime = javaType.psStatsRefreshTime(),
            replicationPairCount = javaType.replicationPairCount().map({ args0 -> args0 }).orElse(null),
            spaceUsageStatus = javaType.spaceUsageStatus().map({ args0 -> args0 }).orElse(null),
            sslCertExpiryDate = javaType.sslCertExpiryDate().map({ args0 -> args0 }).orElse(null),
            sslCertExpiryRemainingDays = javaType.sslCertExpiryRemainingDays().map({ args0 ->
                args0
            }).orElse(null),
            systemLoad = javaType.systemLoad().map({ args0 -> args0 }).orElse(null),
            systemLoadStatus = javaType.systemLoadStatus().map({ args0 -> args0 }).orElse(null),
            throughputInBytes = javaType.throughputInBytes(),
            throughputInMBps = javaType.throughputInMBps(),
            throughputStatus = javaType.throughputStatus(),
            throughputUploadPendingDataInBytes = javaType.throughputUploadPendingDataInBytes(),
            totalMemoryInBytes = javaType.totalMemoryInBytes().map({ args0 -> args0 }).orElse(null),
            totalSpaceInBytes = javaType.totalSpaceInBytes().map({ args0 -> args0 }).orElse(null),
            versionStatus = javaType.versionStatus().map({ args0 -> args0 }).orElse(null),
        )
    }
}
