@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Protection container mapping properties.
 * @property health Health of pairing.
 * @property healthErrorDetails Health error.
 * @property policyFriendlyName Friendly name of replication policy.
 * @property policyId Policy ARM Id.
 * @property providerSpecificDetails Provider specific provider details.
 * @property sourceFabricFriendlyName Friendly name of source fabric.
 * @property sourceProtectionContainerFriendlyName Friendly name of source protection container.
 * @property state Association Status.
 * @property targetFabricFriendlyName Friendly name of target fabric.
 * @property targetProtectionContainerFriendlyName Friendly name of paired container.
 * @property targetProtectionContainerId Paired protection container ARM ID.
 */
public data class ProtectionContainerMappingPropertiesResponse(
    public val health: String? = null,
    public val healthErrorDetails: List<HealthErrorResponse>? = null,
    public val policyFriendlyName: String? = null,
    public val policyId: String? = null,
    public val providerSpecificDetails: Any? = null,
    public val sourceFabricFriendlyName: String? = null,
    public val sourceProtectionContainerFriendlyName: String? = null,
    public val state: String? = null,
    public val targetFabricFriendlyName: String? = null,
    public val targetProtectionContainerFriendlyName: String? = null,
    public val targetProtectionContainerId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.recoveryservices.outputs.ProtectionContainerMappingPropertiesResponse): ProtectionContainerMappingPropertiesResponse = ProtectionContainerMappingPropertiesResponse(
            health = javaType.health().map({ args0 -> args0 }).orElse(null),
            healthErrorDetails = javaType.healthErrorDetails().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.recoveryservices.kotlin.outputs.HealthErrorResponse.Companion.toKotlin(args0)
                })
            }),
            policyFriendlyName = javaType.policyFriendlyName().map({ args0 -> args0 }).orElse(null),
            policyId = javaType.policyId().map({ args0 -> args0 }).orElse(null),
            providerSpecificDetails = javaType.providerSpecificDetails().map({ args0 -> args0 }).orElse(null),
            sourceFabricFriendlyName = javaType.sourceFabricFriendlyName().map({ args0 -> args0 }).orElse(null),
            sourceProtectionContainerFriendlyName = javaType.sourceProtectionContainerFriendlyName().map({ args0 ->
                args0
            }).orElse(null),
            state = javaType.state().map({ args0 -> args0 }).orElse(null),
            targetFabricFriendlyName = javaType.targetFabricFriendlyName().map({ args0 -> args0 }).orElse(null),
            targetProtectionContainerFriendlyName = javaType.targetProtectionContainerFriendlyName().map({ args0 ->
                args0
            }).orElse(null),
            targetProtectionContainerId = javaType.targetProtectionContainerId().map({ args0 ->
                args0
            }).orElse(null),
        )
    }
}
