@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Recovery plan action details.
 * @property actionName The action name.
 * @property customDetails The custom details.
 * @property failoverDirections The list of failover directions.
 * @property failoverTypes The list of failover types.
 */
public data class RecoveryPlanActionResponse(
    public val actionName: String,
    public val customDetails: Any,
    public val failoverDirections: List<String>,
    public val failoverTypes: List<String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.recoveryservices.outputs.RecoveryPlanActionResponse): RecoveryPlanActionResponse = RecoveryPlanActionResponse(
            actionName = javaType.actionName(),
            customDetails = javaType.customDetails(),
            failoverDirections = javaType.failoverDirections().map({ args0 -> args0 }),
            failoverTypes = javaType.failoverTypes().map({ args0 -> args0 }),
        )
    }
}
