@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Recovery plan Automation runbook action details.
 * @property fabricLocation The fabric location.
 * @property instanceType Gets the type of action details (see RecoveryPlanActionDetailsTypes enum for possible values).
 * Expected value is 'AutomationRunbookActionDetails'.
 * @property runbookId The runbook ARM Id.
 * @property timeout The runbook timeout.
 */
public data class RecoveryPlanAutomationRunbookActionDetailsResponse(
    public val fabricLocation: String,
    public val instanceType: String,
    public val runbookId: String? = null,
    public val timeout: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.recoveryservices.outputs.RecoveryPlanAutomationRunbookActionDetailsResponse): RecoveryPlanAutomationRunbookActionDetailsResponse =
            RecoveryPlanAutomationRunbookActionDetailsResponse(
                fabricLocation = javaType.fabricLocation(),
                instanceType = javaType.instanceType(),
                runbookId = javaType.runbookId().map({ args0 -> args0 }).orElse(null),
                timeout = javaType.timeout().map({ args0 -> args0 }).orElse(null),
            )
    }
}
