@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Recovery plan group details.
 * @property endGroupActions The end group actions.
 * @property groupType The group type.
 * @property replicationProtectedItems The list of protected items.
 * @property startGroupActions The start group actions.
 */
public data class RecoveryPlanGroupResponse(
    public val endGroupActions: List<RecoveryPlanActionResponse>? = null,
    public val groupType: String,
    public val replicationProtectedItems: List<RecoveryPlanProtectedItemResponse>? = null,
    public val startGroupActions: List<RecoveryPlanActionResponse>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.recoveryservices.outputs.RecoveryPlanGroupResponse): RecoveryPlanGroupResponse = RecoveryPlanGroupResponse(
            endGroupActions = javaType.endGroupActions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.recoveryservices.kotlin.outputs.RecoveryPlanActionResponse.Companion.toKotlin(args0)
                })
            }),
            groupType = javaType.groupType(),
            replicationProtectedItems = javaType.replicationProtectedItems().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.recoveryservices.kotlin.outputs.RecoveryPlanProtectedItemResponse.Companion.toKotlin(args0)
                })
            }),
            startGroupActions = javaType.startGroupActions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.recoveryservices.kotlin.outputs.RecoveryPlanActionResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
