@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Recovery plan properties.
 * @property allowedOperations The list of allowed operations.
 * @property currentScenario The current scenario details.
 * @property currentScenarioStatus The recovery plan status.
 * @property currentScenarioStatusDescription The recovery plan status description.
 * @property failoverDeploymentModel The failover deployment model.
 * @property friendlyName The friendly name.
 * @property groups The recovery plan groups.
 * @property lastPlannedFailoverTime The start time of the last planned failover.
 * @property lastTestFailoverTime The start time of the last test failover.
 * @property lastUnplannedFailoverTime The start time of the last unplanned failover.
 * @property primaryFabricFriendlyName The primary fabric friendly name.
 * @property primaryFabricId The primary fabric Id.
 * @property providerSpecificDetails The provider id and provider specific details.
 * @property recoveryFabricFriendlyName The recovery fabric friendly name.
 * @property recoveryFabricId The recovery fabric Id.
 * @property replicationProviders The list of replication providers.
 */
public data class RecoveryPlanPropertiesResponse(
    public val allowedOperations: List<String>? = null,
    public val currentScenario: CurrentScenarioDetailsResponse? = null,
    public val currentScenarioStatus: String? = null,
    public val currentScenarioStatusDescription: String? = null,
    public val failoverDeploymentModel: String? = null,
    public val friendlyName: String? = null,
    public val groups: List<RecoveryPlanGroupResponse>? = null,
    public val lastPlannedFailoverTime: String? = null,
    public val lastTestFailoverTime: String? = null,
    public val lastUnplannedFailoverTime: String? = null,
    public val primaryFabricFriendlyName: String? = null,
    public val primaryFabricId: String? = null,
    public val providerSpecificDetails: List<RecoveryPlanA2ADetailsResponse>? = null,
    public val recoveryFabricFriendlyName: String? = null,
    public val recoveryFabricId: String? = null,
    public val replicationProviders: List<String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.recoveryservices.outputs.RecoveryPlanPropertiesResponse): RecoveryPlanPropertiesResponse = RecoveryPlanPropertiesResponse(
            allowedOperations = javaType.allowedOperations().map({ args0 -> args0 }),
            currentScenario = javaType.currentScenario().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.recoveryservices.kotlin.outputs.CurrentScenarioDetailsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            currentScenarioStatus = javaType.currentScenarioStatus().map({ args0 -> args0 }).orElse(null),
            currentScenarioStatusDescription = javaType.currentScenarioStatusDescription().map({ args0 ->
                args0
            }).orElse(null),
            failoverDeploymentModel = javaType.failoverDeploymentModel().map({ args0 -> args0 }).orElse(null),
            friendlyName = javaType.friendlyName().map({ args0 -> args0 }).orElse(null),
            groups = javaType.groups().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.recoveryservices.kotlin.outputs.RecoveryPlanGroupResponse.Companion.toKotlin(args0)
                })
            }),
            lastPlannedFailoverTime = javaType.lastPlannedFailoverTime().map({ args0 -> args0 }).orElse(null),
            lastTestFailoverTime = javaType.lastTestFailoverTime().map({ args0 -> args0 }).orElse(null),
            lastUnplannedFailoverTime = javaType.lastUnplannedFailoverTime().map({ args0 ->
                args0
            }).orElse(null),
            primaryFabricFriendlyName = javaType.primaryFabricFriendlyName().map({ args0 ->
                args0
            }).orElse(null),
            primaryFabricId = javaType.primaryFabricId().map({ args0 -> args0 }).orElse(null),
            providerSpecificDetails = javaType.providerSpecificDetails().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.recoveryservices.kotlin.outputs.RecoveryPlanA2ADetailsResponse.Companion.toKotlin(args0)
                })
            }),
            recoveryFabricFriendlyName = javaType.recoveryFabricFriendlyName().map({ args0 ->
                args0
            }).orElse(null),
            recoveryFabricId = javaType.recoveryFabricId().map({ args0 -> args0 }).orElse(null),
            replicationProviders = javaType.replicationProviders().map({ args0 -> args0 }),
        )
    }
}
