@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * Extended location of the resource.
 * @property biosId The BIOS ID.
 * @property clusterNodeFqdn The cluster node name.
 * @property isSharedDiskVirtualNode A value indicating whether this represents virtual entity hosting all the shared disks.
 * @property machineId The machine ID.
 */
public data class RegisteredClusterNodesResponse(
    public val biosId: String? = null,
    public val clusterNodeFqdn: String? = null,
    public val isSharedDiskVirtualNode: Boolean? = null,
    public val machineId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.recoveryservices.outputs.RegisteredClusterNodesResponse): RegisteredClusterNodesResponse = RegisteredClusterNodesResponse(
            biosId = javaType.biosId().map({ args0 -> args0 }).orElse(null),
            clusterNodeFqdn = javaType.clusterNodeFqdn().map({ args0 -> args0 }).orElse(null),
            isSharedDiskVirtualNode = javaType.isSharedDiskVirtualNode().map({ args0 -> args0 }).orElse(null),
            machineId = javaType.machineId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
