@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Replication agent details.
 * @property biosId The replication agent Bios Id.
 * @property fabricObjectId The fabric object Id.
 * @property fqdn The replication agent Fqdn.
 * @property health The health of the replication agent.
 * @property healthErrors The health errors.
 * @property id The replication agent Id.
 * @property lastHeartbeatUtc The last heartbeat received from the replication agent.
 * @property name The replication agent name.
 * @property version The version.
 */
public data class ReplicationAgentDetailsResponse(
    public val biosId: String,
    public val fabricObjectId: String,
    public val fqdn: String,
    public val health: String,
    public val healthErrors: List<HealthErrorResponse>,
    public val id: String,
    public val lastHeartbeatUtc: String,
    public val name: String,
    public val version: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.recoveryservices.outputs.ReplicationAgentDetailsResponse): ReplicationAgentDetailsResponse = ReplicationAgentDetailsResponse(
            biosId = javaType.biosId(),
            fabricObjectId = javaType.fabricObjectId(),
            fqdn = javaType.fqdn(),
            health = javaType.health(),
            healthErrors = javaType.healthErrors().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.recoveryservices.kotlin.outputs.HealthErrorResponse.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            lastHeartbeatUtc = javaType.lastHeartbeatUtc(),
            name = javaType.name(),
            version = javaType.version(),
        )
    }
}
