@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Replication protected item custom data details.
 * @property activeLocation The Current active location of the PE.
 * @property allowedOperations The allowed operations on the Replication protected item.
 * @property currentScenario The current scenario.
 * @property eventCorrelationId The correlation Id for events associated with this protected item.
 * @property failoverHealth The consolidated failover health for the VM.
 * @property failoverRecoveryPointId The recovery point ARM Id to which the Vm was failed over.
 * @property friendlyName The name.
 * @property healthErrors List of health errors.
 * @property lastSuccessfulFailoverTime The Last successful failover time.
 * @property lastSuccessfulTestFailoverTime The Last successful test failover time.
 * @property policyFriendlyName The name of Policy governing this PE.
 * @property policyId The ID of Policy governing this PE.
 * @property primaryFabricFriendlyName The friendly name of the primary fabric.
 * @property primaryFabricProvider The fabric provider of the primary fabric.
 * @property primaryProtectionContainerFriendlyName The name of primary protection container friendly name.
 * @property protectableItemId The protected item ARM Id.
 * @property protectedItemType The type of protected item type.
 * @property protectionState The protection status.
 * @property protectionStateDescription The protection state description.
 * @property providerSpecificDetails The Replication provider custom settings.
 * @property recoveryContainerId The recovery container Id.
 * @property recoveryFabricFriendlyName The friendly name of recovery fabric.
 * @property recoveryFabricId The Arm Id of recovery fabric.
 * @property recoveryProtectionContainerFriendlyName The name of recovery container friendly name.
 * @property recoveryServicesProviderId The recovery provider ARM Id.
 * @property replicationHealth The consolidated protection health for the VM taking any issues with SRS as well as all the replication units associated with the VM's replication group into account. This is a string representation of the ProtectionHealth enumeration.
 * @property switchProviderState The switch provider state.
 * @property switchProviderStateDescription The switch provider state description.
 * @property testFailoverState The Test failover state.
 * @property testFailoverStateDescription The Test failover state description.
 */
public data class ReplicationProtectedItemPropertiesResponse(
    public val activeLocation: String? = null,
    public val allowedOperations: List<String>? = null,
    public val currentScenario: CurrentScenarioDetailsResponse? = null,
    public val eventCorrelationId: String? = null,
    public val failoverHealth: String? = null,
    public val failoverRecoveryPointId: String? = null,
    public val friendlyName: String? = null,
    public val healthErrors: List<HealthErrorResponse>? = null,
    public val lastSuccessfulFailoverTime: String? = null,
    public val lastSuccessfulTestFailoverTime: String? = null,
    public val policyFriendlyName: String? = null,
    public val policyId: String? = null,
    public val primaryFabricFriendlyName: String? = null,
    public val primaryFabricProvider: String? = null,
    public val primaryProtectionContainerFriendlyName: String? = null,
    public val protectableItemId: String? = null,
    public val protectedItemType: String? = null,
    public val protectionState: String? = null,
    public val protectionStateDescription: String? = null,
    public val providerSpecificDetails: Any? = null,
    public val recoveryContainerId: String? = null,
    public val recoveryFabricFriendlyName: String? = null,
    public val recoveryFabricId: String? = null,
    public val recoveryProtectionContainerFriendlyName: String? = null,
    public val recoveryServicesProviderId: String? = null,
    public val replicationHealth: String? = null,
    public val switchProviderState: String? = null,
    public val switchProviderStateDescription: String? = null,
    public val testFailoverState: String? = null,
    public val testFailoverStateDescription: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.recoveryservices.outputs.ReplicationProtectedItemPropertiesResponse): ReplicationProtectedItemPropertiesResponse = ReplicationProtectedItemPropertiesResponse(
            activeLocation = javaType.activeLocation().map({ args0 -> args0 }).orElse(null),
            allowedOperations = javaType.allowedOperations().map({ args0 -> args0 }),
            currentScenario = javaType.currentScenario().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.recoveryservices.kotlin.outputs.CurrentScenarioDetailsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            eventCorrelationId = javaType.eventCorrelationId().map({ args0 -> args0 }).orElse(null),
            failoverHealth = javaType.failoverHealth().map({ args0 -> args0 }).orElse(null),
            failoverRecoveryPointId = javaType.failoverRecoveryPointId().map({ args0 -> args0 }).orElse(null),
            friendlyName = javaType.friendlyName().map({ args0 -> args0 }).orElse(null),
            healthErrors = javaType.healthErrors().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.recoveryservices.kotlin.outputs.HealthErrorResponse.Companion.toKotlin(args0)
                })
            }),
            lastSuccessfulFailoverTime = javaType.lastSuccessfulFailoverTime().map({ args0 ->
                args0
            }).orElse(null),
            lastSuccessfulTestFailoverTime = javaType.lastSuccessfulTestFailoverTime().map({ args0 ->
                args0
            }).orElse(null),
            policyFriendlyName = javaType.policyFriendlyName().map({ args0 -> args0 }).orElse(null),
            policyId = javaType.policyId().map({ args0 -> args0 }).orElse(null),
            primaryFabricFriendlyName = javaType.primaryFabricFriendlyName().map({ args0 ->
                args0
            }).orElse(null),
            primaryFabricProvider = javaType.primaryFabricProvider().map({ args0 -> args0 }).orElse(null),
            primaryProtectionContainerFriendlyName = javaType.primaryProtectionContainerFriendlyName().map({ args0 ->
                args0
            }).orElse(null),
            protectableItemId = javaType.protectableItemId().map({ args0 -> args0 }).orElse(null),
            protectedItemType = javaType.protectedItemType().map({ args0 -> args0 }).orElse(null),
            protectionState = javaType.protectionState().map({ args0 -> args0 }).orElse(null),
            protectionStateDescription = javaType.protectionStateDescription().map({ args0 ->
                args0
            }).orElse(null),
            providerSpecificDetails = javaType.providerSpecificDetails().map({ args0 -> args0 }).orElse(null),
            recoveryContainerId = javaType.recoveryContainerId().map({ args0 -> args0 }).orElse(null),
            recoveryFabricFriendlyName = javaType.recoveryFabricFriendlyName().map({ args0 ->
                args0
            }).orElse(null),
            recoveryFabricId = javaType.recoveryFabricId().map({ args0 -> args0 }).orElse(null),
            recoveryProtectionContainerFriendlyName = javaType.recoveryProtectionContainerFriendlyName().map({ args0 ->
                args0
            }).orElse(null),
            recoveryServicesProviderId = javaType.recoveryServicesProviderId().map({ args0 ->
                args0
            }).orElse(null),
            replicationHealth = javaType.replicationHealth().map({ args0 -> args0 }).orElse(null),
            switchProviderState = javaType.switchProviderState().map({ args0 -> args0 }).orElse(null),
            switchProviderStateDescription = javaType.switchProviderStateDescription().map({ args0 ->
                args0
            }).orElse(null),
            testFailoverState = javaType.testFailoverState().map({ args0 -> args0 }).orElse(null),
            testFailoverStateDescription = javaType.testFailoverStateDescription().map({ args0 ->
                args0
            }).orElse(null),
        )
    }
}
