@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Replication protection cluster custom data details.
 * @property activeLocation The Current active location of the Protection cluster.
 * @property agentClusterId The Agent cluster Id.
 * @property allowedOperations The allowed operations on the Replication protection cluster.
 * @property areAllClusterNodesRegistered A value indicating whether all nodes of the cluster are registered or not.
 * @property clusterFqdn The cluster FQDN.
 * @property clusterNodeFqdns The List of cluster Node FQDNs.
 * @property clusterProtectedItemIds The List of Protected Item Id's.
 * @property clusterRegisteredNodes The registered node details.
 * @property currentScenario The current scenario.
 * @property healthErrors List of health errors.
 * @property lastSuccessfulFailoverTime The last successful failover time.
 * @property lastSuccessfulTestFailoverTime The last successful test failover time.
 * @property policyFriendlyName The name of Policy governing this PE.
 * @property policyId The Policy Id.
 * @property primaryFabricFriendlyName The friendly name of the primary fabric.
 * @property primaryFabricProvider The fabric provider of the primary fabric.
 * @property primaryProtectionContainerFriendlyName The name of primary protection container friendly name.
 * @property protectionClusterType The type of protection cluster type.
 * @property protectionState The protection status.
 * @property protectionStateDescription The protection state description.
 * @property providerSpecificDetails The Replication cluster provider custom settings.
 * @property provisioningState The provisioning state of the cluster.
 * @property recoveryContainerId The recovery container Id.
 * @property recoveryFabricFriendlyName The friendly name of recovery fabric.
 * @property recoveryFabricId The Arm Id of recovery fabric.
 * @property recoveryProtectionContainerFriendlyName The name of recovery container friendly name.
 * @property replicationHealth The consolidated protection health for the VM taking any issues with SRS as well as all the replication units associated with the VM's replication group into account. This is a string representation of the ProtectionHealth enumeration.
 * @property sharedDiskProperties The shared disk properties.
 * @property testFailoverState The Test failover state.
 * @property testFailoverStateDescription The Test failover state description.
 */
public data class ReplicationProtectionClusterPropertiesResponse(
    public val activeLocation: String? = null,
    public val agentClusterId: String? = null,
    public val allowedOperations: List<String>? = null,
    public val areAllClusterNodesRegistered: Boolean? = null,
    public val clusterFqdn: String? = null,
    public val clusterNodeFqdns: List<String>? = null,
    public val clusterProtectedItemIds: List<String>? = null,
    public val clusterRegisteredNodes: List<RegisteredClusterNodesResponse>? = null,
    public val currentScenario: CurrentScenarioDetailsResponse? = null,
    public val healthErrors: List<HealthErrorResponse>? = null,
    public val lastSuccessfulFailoverTime: String? = null,
    public val lastSuccessfulTestFailoverTime: String? = null,
    public val policyFriendlyName: String? = null,
    public val policyId: String? = null,
    public val primaryFabricFriendlyName: String? = null,
    public val primaryFabricProvider: String? = null,
    public val primaryProtectionContainerFriendlyName: String? = null,
    public val protectionClusterType: String? = null,
    public val protectionState: String? = null,
    public val protectionStateDescription: String? = null,
    public val providerSpecificDetails: A2AReplicationProtectionClusterDetailsResponse? = null,
    public val provisioningState: String,
    public val recoveryContainerId: String? = null,
    public val recoveryFabricFriendlyName: String? = null,
    public val recoveryFabricId: String? = null,
    public val recoveryProtectionContainerFriendlyName: String? = null,
    public val replicationHealth: String? = null,
    public val sharedDiskProperties: SharedDiskReplicationItemPropertiesResponse? = null,
    public val testFailoverState: String? = null,
    public val testFailoverStateDescription: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.recoveryservices.outputs.ReplicationProtectionClusterPropertiesResponse): ReplicationProtectionClusterPropertiesResponse =
            ReplicationProtectionClusterPropertiesResponse(
                activeLocation = javaType.activeLocation().map({ args0 -> args0 }).orElse(null),
                agentClusterId = javaType.agentClusterId().map({ args0 -> args0 }).orElse(null),
                allowedOperations = javaType.allowedOperations().map({ args0 -> args0 }),
                areAllClusterNodesRegistered = javaType.areAllClusterNodesRegistered().map({ args0 ->
                    args0
                }).orElse(null),
                clusterFqdn = javaType.clusterFqdn().map({ args0 -> args0 }).orElse(null),
                clusterNodeFqdns = javaType.clusterNodeFqdns().map({ args0 -> args0 }),
                clusterProtectedItemIds = javaType.clusterProtectedItemIds().map({ args0 -> args0 }),
                clusterRegisteredNodes = javaType.clusterRegisteredNodes().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.recoveryservices.kotlin.outputs.RegisteredClusterNodesResponse.Companion.toKotlin(args0)
                    })
                }),
                currentScenario = javaType.currentScenario().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.recoveryservices.kotlin.outputs.CurrentScenarioDetailsResponse.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                healthErrors = javaType.healthErrors().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.recoveryservices.kotlin.outputs.HealthErrorResponse.Companion.toKotlin(args0)
                    })
                }),
                lastSuccessfulFailoverTime = javaType.lastSuccessfulFailoverTime().map({ args0 ->
                    args0
                }).orElse(null),
                lastSuccessfulTestFailoverTime = javaType.lastSuccessfulTestFailoverTime().map({ args0 ->
                    args0
                }).orElse(null),
                policyFriendlyName = javaType.policyFriendlyName().map({ args0 -> args0 }).orElse(null),
                policyId = javaType.policyId().map({ args0 -> args0 }).orElse(null),
                primaryFabricFriendlyName = javaType.primaryFabricFriendlyName().map({ args0 ->
                    args0
                }).orElse(null),
                primaryFabricProvider = javaType.primaryFabricProvider().map({ args0 -> args0 }).orElse(null),
                primaryProtectionContainerFriendlyName = javaType.primaryProtectionContainerFriendlyName().map({ args0 ->
                    args0
                }).orElse(null),
                protectionClusterType = javaType.protectionClusterType().map({ args0 -> args0 }).orElse(null),
                protectionState = javaType.protectionState().map({ args0 -> args0 }).orElse(null),
                protectionStateDescription = javaType.protectionStateDescription().map({ args0 ->
                    args0
                }).orElse(null),
                providerSpecificDetails = javaType.providerSpecificDetails().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.recoveryservices.kotlin.outputs.A2AReplicationProtectionClusterDetailsResponse.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                provisioningState = javaType.provisioningState(),
                recoveryContainerId = javaType.recoveryContainerId().map({ args0 -> args0 }).orElse(null),
                recoveryFabricFriendlyName = javaType.recoveryFabricFriendlyName().map({ args0 ->
                    args0
                }).orElse(null),
                recoveryFabricId = javaType.recoveryFabricId().map({ args0 -> args0 }).orElse(null),
                recoveryProtectionContainerFriendlyName = javaType.recoveryProtectionContainerFriendlyName().map({ args0 ->
                    args0
                }).orElse(null),
                replicationHealth = javaType.replicationHealth().map({ args0 -> args0 }).orElse(null),
                sharedDiskProperties = javaType.sharedDiskProperties().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.recoveryservices.kotlin.outputs.SharedDiskReplicationItemPropertiesResponse.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                testFailoverState = javaType.testFailoverState().map({ args0 -> args0 }).orElse(null),
                testFailoverStateDescription = javaType.testFailoverStateDescription().map({ args0 ->
                    args0
                }).orElse(null),
            )
    }
}
