@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Retention duration.
 * @property count Count of duration types. Retention duration is obtained by the counting the duration type Count times.
 * For example, when Count = 3 and DurationType = Weeks, retention duration will be three weeks.
 * @property durationType Retention duration type of retention policy.
 */
public data class RetentionDurationResponse(
    public val count: Int? = null,
    public val durationType: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.recoveryservices.outputs.RetentionDurationResponse): RetentionDurationResponse = RetentionDurationResponse(
            count = javaType.count().map({ args0 -> args0 }).orElse(null),
            durationType = javaType.durationType().map({ args0 -> args0 }).orElse(null),
        )
    }
}
