@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Shared Disk Replication item custom data details.
 * @property activeLocation The Current active location of the PE.
 * @property allowedOperations The allowed operations on the Replication protected item.
 * @property currentScenario The current scenario.
 * @property healthErrors List of health errors.
 * @property protectionState The protection state of shared disk.
 * @property replicationHealth The consolidated protection health for the VM taking any issues with SRS as well as all the replication units associated with the VM's replication group into account. This is a string representation of the ProtectionHealth enumeration.
 * @property sharedDiskProviderSpecificDetails The Replication provider custom settings.
 * @property testFailoverState The tfo state of shared disk.
 */
public data class SharedDiskReplicationItemPropertiesResponse(
    public val activeLocation: String? = null,
    public val allowedOperations: List<String>? = null,
    public val currentScenario: CurrentScenarioDetailsResponse? = null,
    public val healthErrors: List<HealthErrorResponse>? = null,
    public val protectionState: String? = null,
    public val replicationHealth: String? = null,
    public val sharedDiskProviderSpecificDetails: A2ASharedDiskReplicationDetailsResponse? = null,
    public val testFailoverState: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.recoveryservices.outputs.SharedDiskReplicationItemPropertiesResponse): SharedDiskReplicationItemPropertiesResponse = SharedDiskReplicationItemPropertiesResponse(
            activeLocation = javaType.activeLocation().map({ args0 -> args0 }).orElse(null),
            allowedOperations = javaType.allowedOperations().map({ args0 -> args0 }),
            currentScenario = javaType.currentScenario().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.recoveryservices.kotlin.outputs.CurrentScenarioDetailsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            healthErrors = javaType.healthErrors().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.recoveryservices.kotlin.outputs.HealthErrorResponse.Companion.toKotlin(args0)
                })
            }),
            protectionState = javaType.protectionState().map({ args0 -> args0 }).orElse(null),
            replicationHealth = javaType.replicationHealth().map({ args0 -> args0 }).orElse(null),
            sharedDiskProviderSpecificDetails = javaType.sharedDiskProviderSpecificDetails().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.recoveryservices.kotlin.outputs.A2ASharedDiskReplicationDetailsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            testFailoverState = javaType.testFailoverState().map({ args0 -> args0 }).orElse(null),
        )
    }
}
