@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Simple policy schedule.
 * @property hourlySchedule Hourly Schedule of this Policy
 * @property schedulePolicyType This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
 * Expected value is 'SimpleSchedulePolicy'.
 * @property scheduleRunDays List of days of week this schedule has to be run.
 * @property scheduleRunFrequency Frequency of the schedule operation of this policy.
 * @property scheduleRunTimes List of times of day this schedule has to be run.
 * @property scheduleWeeklyFrequency At every number weeks this schedule has to be run.
 */
public data class SimpleSchedulePolicyResponse(
    public val hourlySchedule: HourlyScheduleResponse? = null,
    public val schedulePolicyType: String,
    public val scheduleRunDays: List<String>? = null,
    public val scheduleRunFrequency: String? = null,
    public val scheduleRunTimes: List<String>? = null,
    public val scheduleWeeklyFrequency: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.recoveryservices.outputs.SimpleSchedulePolicyResponse): SimpleSchedulePolicyResponse = SimpleSchedulePolicyResponse(
            hourlySchedule = javaType.hourlySchedule().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.recoveryservices.kotlin.outputs.HourlyScheduleResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            schedulePolicyType = javaType.schedulePolicyType(),
            scheduleRunDays = javaType.scheduleRunDays().map({ args0 -> args0 }),
            scheduleRunFrequency = javaType.scheduleRunFrequency().map({ args0 -> args0 }).orElse(null),
            scheduleRunTimes = javaType.scheduleRunTimes().map({ args0 -> args0 }),
            scheduleWeeklyFrequency = javaType.scheduleWeeklyFrequency().map({ args0 -> args0 }).orElse(null),
        )
    }
}
