@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Identifies the unique system identifier for each Azure resource.
 * @property capacity The sku capacity
 * @property family The sku family
 * @property name Name of SKU is RS0 (Recovery Services 0th version) and the tier is standard tier. They do not have affect on backend storage redundancy or any other vault settings. To manage storage redundancy, use the backupstorageconfig
 * @property size The sku size
 * @property tier The Sku tier.
 */
public data class SkuResponse(
    public val capacity: String? = null,
    public val family: String? = null,
    public val name: String,
    public val size: String? = null,
    public val tier: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.recoveryservices.outputs.SkuResponse): SkuResponse = SkuResponse(
            capacity = javaType.capacity().map({ args0 -> args0 }).orElse(null),
            family = javaType.family().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            size = javaType.size().map({ args0 -> args0 }).orElse(null),
            tier = javaType.tier().map({ args0 -> args0 }).orElse(null),
        )
    }
}
