@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Soft delete Settings of vault
 * @property softDeleteRetentionPeriodInDays Soft delete retention period in days
 * @property softDeleteState
 */
public data class SoftDeleteSettingsResponse(
    public val softDeleteRetentionPeriodInDays: Int? = null,
    public val softDeleteState: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.recoveryservices.outputs.SoftDeleteSettingsResponse): SoftDeleteSettingsResponse = SoftDeleteSettingsResponse(
            softDeleteRetentionPeriodInDays = javaType.softDeleteRetentionPeriodInDays().map({ args0 ->
                args0
            }).orElse(null),
            softDeleteState = javaType.softDeleteState().map({ args0 -> args0 }).orElse(null),
        )
    }
}
