@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.outputs

import com.pulumi.core.Either
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Sub-protection policy which includes schedule and retention
 * @property policyType Type of backup policy type
 * @property retentionPolicy Retention policy with the details on backup copy retention ranges.
 * @property schedulePolicy Backup schedule specified as part of backup policy.
 * @property tieringPolicy Tiering policy to automatically move RPs to another tier.
 * Key is Target Tier, defined in RecoveryPointTierType enum.
 * Tiering policy specifies the criteria to move RP to the target tier.
 */
public data class SubProtectionPolicyResponse(
    public val policyType: String? = null,
    public val retentionPolicy: Either<LongTermRetentionPolicyResponse, SimpleRetentionPolicyResponse>? = null,
    public val schedulePolicy: Any? = null,
    public val tieringPolicy: Map<String, TieringPolicyResponse>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.recoveryservices.outputs.SubProtectionPolicyResponse): SubProtectionPolicyResponse = SubProtectionPolicyResponse(
            policyType = javaType.policyType().map({ args0 -> args0 }).orElse(null),
            retentionPolicy = javaType.retentionPolicy().map({ args0 ->
                args0.transform(
                    { args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.recoveryservices.kotlin.outputs.LongTermRetentionPolicyResponse.Companion.toKotlin(args0)
                        })
                    },
                    { args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.recoveryservices.kotlin.outputs.SimpleRetentionPolicyResponse.Companion.toKotlin(args0)
                        })
                    },
                )
            }).orElse(null),
            schedulePolicy = javaType.schedulePolicy().map({ args0 -> args0 }).orElse(null),
            tieringPolicy = javaType.tieringPolicy().map({ args0 ->
                args0.key.to(
                    args0.value.let({ args0 ->
                        com.pulumi.azurenative.recoveryservices.kotlin.outputs.TieringPolicyResponse.Companion.toKotlin(args0)
                    }),
                )
            }).toMap(),
        )
    }
}
