@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Details for upgrading vault.
 * @property endTimeUtc UTC time at which the upgrade operation has ended.
 * @property lastUpdatedTimeUtc UTC time at which the upgrade operation status was last updated.
 * @property message Message to the user containing information about the upgrade operation.
 * @property operationId ID of the vault upgrade operation.
 * @property previousResourceId Resource ID of the vault before the upgrade.
 * @property startTimeUtc UTC time at which the upgrade operation has started.
 * @property status Status of the vault upgrade operation.
 * @property triggerType The way the vault upgrade was triggered.
 * @property upgradedResourceId Resource ID of the upgraded vault.
 */
public data class UpgradeDetailsResponse(
    public val endTimeUtc: String,
    public val lastUpdatedTimeUtc: String,
    public val message: String,
    public val operationId: String,
    public val previousResourceId: String,
    public val startTimeUtc: String,
    public val status: String,
    public val triggerType: String,
    public val upgradedResourceId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.recoveryservices.outputs.UpgradeDetailsResponse): UpgradeDetailsResponse = UpgradeDetailsResponse(
            endTimeUtc = javaType.endTimeUtc(),
            lastUpdatedTimeUtc = javaType.lastUpdatedTimeUtc(),
            message = javaType.message(),
            operationId = javaType.operationId(),
            previousResourceId = javaType.previousResourceId(),
            startTimeUtc = javaType.startTimeUtc(),
            status = javaType.status(),
            triggerType = javaType.triggerType(),
            upgradedResourceId = javaType.upgradedResourceId(),
        )
    }
}
