@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * A resource identity that is managed by the user of the service.
 * @property clientId The client ID of the user-assigned identity.
 * @property principalId The principal ID of the user-assigned identity.
 */
public data class UserIdentityResponse(
    public val clientId: String,
    public val principalId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.recoveryservices.outputs.UserIdentityResponse): UserIdentityResponse = UserIdentityResponse(
            clientId = javaType.clientId(),
            principalId = javaType.principalId(),
        )
    }
}
