@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.outputs

import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * VMwareCbt provider specific settings.
 * @property confidentialVmKeyVaultId The confidential VM key vault Id for ADE installation.
 * @property dataMoverRunAsAccountId The data mover run as account Id.
 * @property firmwareType The firmware type.
 * @property initialSeedingProgressPercentage The initial seeding progress percentage.
 * @property initialSeedingRetryCount The initial seeding retry count.
 * @property instanceType Gets the instance type.
 * Expected value is 'VMwareCbt'.
 * @property lastRecoveryPointId The last recovery point Id.
 * @property lastRecoveryPointReceived The last recovery point received time.
 * @property licenseType License Type of the VM to be used.
 * @property migrationProgressPercentage The migration progress percentage.
 * @property migrationRecoveryPointId The recovery point Id to which the VM was migrated.
 * @property osName The name of the OS on the VM.
 * @property osType The type of the OS on the VM.
 * @property performAutoResync A value indicating whether auto resync is to be done.
 * @property protectedDisks The list of protected disks.
 * @property resumeProgressPercentage The resume progress percentage.
 * @property resumeRetryCount The resume retry count.
 * @property resyncProgressPercentage The resync progress percentage.
 * @property resyncRequired A value indicating whether resync is required.
 * @property resyncRetryCount The resync retry count.
 * @property resyncState The resync state.
 * @property seedDiskTags The tags for the seed disks.
 * @property snapshotRunAsAccountId The snapshot run as account Id.
 * @property sqlServerLicenseType The SQL Server license type.
 * @property storageAccountId The replication storage account ARM Id. This is applicable only for the blob based replication test hook.
 * @property supportedOSVersions List of supported inplace OS Upgrade versions.
 * @property targetAvailabilitySetId The target availability set Id.
 * @property targetAvailabilityZone The target availability zone.
 * @property targetBootDiagnosticsStorageAccountId The target boot diagnostics storage account ARM Id.
 * @property targetDiskTags The tags for the target disks.
 * @property targetGeneration The target generation.
 * @property targetLocation The target location.
 * @property targetNetworkId The target network Id.
 * @property targetNicTags The tags for the target NICs.
 * @property targetProximityPlacementGroupId The target proximity placement group Id.
 * @property targetResourceGroupId The target resource group Id.
 * @property targetVmName Target VM name.
 * @property targetVmSecurityProfile The target VM security profile.
 * @property targetVmSize The target VM size.
 * @property targetVmTags The target VM tags.
 * @property testNetworkId The test network Id.
 * @property vmNics The network details.
 * @property vmwareMachineId The ARM Id of the VM discovered in VMware.
 */
public data class VMwareCbtMigrationDetailsResponse(
    public val confidentialVmKeyVaultId: String? = null,
    public val dataMoverRunAsAccountId: String,
    public val firmwareType: String,
    public val initialSeedingProgressPercentage: Int,
    public val initialSeedingRetryCount: Double,
    public val instanceType: String,
    public val lastRecoveryPointId: String,
    public val lastRecoveryPointReceived: String,
    public val licenseType: String? = null,
    public val migrationProgressPercentage: Int,
    public val migrationRecoveryPointId: String,
    public val osName: String,
    public val osType: String,
    public val performAutoResync: String? = null,
    public val protectedDisks: List<VMwareCbtProtectedDiskDetailsResponse>? = null,
    public val resumeProgressPercentage: Int,
    public val resumeRetryCount: Double,
    public val resyncProgressPercentage: Int,
    public val resyncRequired: String,
    public val resyncRetryCount: Double,
    public val resyncState: String,
    public val seedDiskTags: Map<String, String>? = null,
    public val snapshotRunAsAccountId: String,
    public val sqlServerLicenseType: String? = null,
    public val storageAccountId: String,
    public val supportedOSVersions: List<String>? = null,
    public val targetAvailabilitySetId: String? = null,
    public val targetAvailabilityZone: String? = null,
    public val targetBootDiagnosticsStorageAccountId: String? = null,
    public val targetDiskTags: Map<String, String>? = null,
    public val targetGeneration: String,
    public val targetLocation: String,
    public val targetNetworkId: String? = null,
    public val targetNicTags: Map<String, String>? = null,
    public val targetProximityPlacementGroupId: String? = null,
    public val targetResourceGroupId: String? = null,
    public val targetVmName: String? = null,
    public val targetVmSecurityProfile: VMwareCbtSecurityProfilePropertiesResponse? = null,
    public val targetVmSize: String? = null,
    public val targetVmTags: Map<String, String>? = null,
    public val testNetworkId: String? = null,
    public val vmNics: List<VMwareCbtNicDetailsResponse>? = null,
    public val vmwareMachineId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.recoveryservices.outputs.VMwareCbtMigrationDetailsResponse): VMwareCbtMigrationDetailsResponse = VMwareCbtMigrationDetailsResponse(
            confidentialVmKeyVaultId = javaType.confidentialVmKeyVaultId().map({ args0 -> args0 }).orElse(null),
            dataMoverRunAsAccountId = javaType.dataMoverRunAsAccountId(),
            firmwareType = javaType.firmwareType(),
            initialSeedingProgressPercentage = javaType.initialSeedingProgressPercentage(),
            initialSeedingRetryCount = javaType.initialSeedingRetryCount(),
            instanceType = javaType.instanceType(),
            lastRecoveryPointId = javaType.lastRecoveryPointId(),
            lastRecoveryPointReceived = javaType.lastRecoveryPointReceived(),
            licenseType = javaType.licenseType().map({ args0 -> args0 }).orElse(null),
            migrationProgressPercentage = javaType.migrationProgressPercentage(),
            migrationRecoveryPointId = javaType.migrationRecoveryPointId(),
            osName = javaType.osName(),
            osType = javaType.osType(),
            performAutoResync = javaType.performAutoResync().map({ args0 -> args0 }).orElse(null),
            protectedDisks = javaType.protectedDisks().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.recoveryservices.kotlin.outputs.VMwareCbtProtectedDiskDetailsResponse.Companion.toKotlin(args0)
                })
            }),
            resumeProgressPercentage = javaType.resumeProgressPercentage(),
            resumeRetryCount = javaType.resumeRetryCount(),
            resyncProgressPercentage = javaType.resyncProgressPercentage(),
            resyncRequired = javaType.resyncRequired(),
            resyncRetryCount = javaType.resyncRetryCount(),
            resyncState = javaType.resyncState(),
            seedDiskTags = javaType.seedDiskTags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            snapshotRunAsAccountId = javaType.snapshotRunAsAccountId(),
            sqlServerLicenseType = javaType.sqlServerLicenseType().map({ args0 -> args0 }).orElse(null),
            storageAccountId = javaType.storageAccountId(),
            supportedOSVersions = javaType.supportedOSVersions().map({ args0 -> args0 }),
            targetAvailabilitySetId = javaType.targetAvailabilitySetId().map({ args0 -> args0 }).orElse(null),
            targetAvailabilityZone = javaType.targetAvailabilityZone().map({ args0 -> args0 }).orElse(null),
            targetBootDiagnosticsStorageAccountId = javaType.targetBootDiagnosticsStorageAccountId().map({ args0 ->
                args0
            }).orElse(null),
            targetDiskTags = javaType.targetDiskTags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            targetGeneration = javaType.targetGeneration(),
            targetLocation = javaType.targetLocation(),
            targetNetworkId = javaType.targetNetworkId().map({ args0 -> args0 }).orElse(null),
            targetNicTags = javaType.targetNicTags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            targetProximityPlacementGroupId = javaType.targetProximityPlacementGroupId().map({ args0 ->
                args0
            }).orElse(null),
            targetResourceGroupId = javaType.targetResourceGroupId().map({ args0 -> args0 }).orElse(null),
            targetVmName = javaType.targetVmName().map({ args0 -> args0 }).orElse(null),
            targetVmSecurityProfile = javaType.targetVmSecurityProfile().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.recoveryservices.kotlin.outputs.VMwareCbtSecurityProfilePropertiesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            targetVmSize = javaType.targetVmSize().map({ args0 -> args0 }).orElse(null),
            targetVmTags = javaType.targetVmTags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            testNetworkId = javaType.testNetworkId().map({ args0 -> args0 }).orElse(null),
            vmNics = javaType.vmNics().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.recoveryservices.kotlin.outputs.VMwareCbtNicDetailsResponse.Companion.toKotlin(args0)
                })
            }),
            vmwareMachineId = javaType.vmwareMachineId(),
        )
    }
}
