@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * VMwareCbt NIC details.
 * @property isPrimaryNic A value indicating whether this is the primary NIC.
 * @property isSelectedForMigration A value indicating whether this NIC is selected for migration.
 * @property nicId The NIC Id.
 * @property sourceIPAddress The source IP address.
 * @property sourceIPAddressType The source IP address type.
 * @property sourceNetworkId Source network Id.
 * @property targetIPAddress The target IP address.
 * @property targetIPAddressType The target IP address type.
 * @property targetNicName Target NIC name.
 * @property targetSubnetName Target subnet name.
 * @property testIPAddress The test IP address.
 * @property testIPAddressType The test IP address type.
 * @property testNetworkId Source network Id.
 * @property testSubnetName Test subnet name.
 */
public data class VMwareCbtNicDetailsResponse(
    public val isPrimaryNic: String? = null,
    public val isSelectedForMigration: String? = null,
    public val nicId: String,
    public val sourceIPAddress: String,
    public val sourceIPAddressType: String,
    public val sourceNetworkId: String,
    public val targetIPAddress: String? = null,
    public val targetIPAddressType: String? = null,
    public val targetNicName: String? = null,
    public val targetSubnetName: String? = null,
    public val testIPAddress: String? = null,
    public val testIPAddressType: String? = null,
    public val testNetworkId: String? = null,
    public val testSubnetName: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.recoveryservices.outputs.VMwareCbtNicDetailsResponse): VMwareCbtNicDetailsResponse = VMwareCbtNicDetailsResponse(
            isPrimaryNic = javaType.isPrimaryNic().map({ args0 -> args0 }).orElse(null),
            isSelectedForMigration = javaType.isSelectedForMigration().map({ args0 -> args0 }).orElse(null),
            nicId = javaType.nicId(),
            sourceIPAddress = javaType.sourceIPAddress(),
            sourceIPAddressType = javaType.sourceIPAddressType(),
            sourceNetworkId = javaType.sourceNetworkId(),
            targetIPAddress = javaType.targetIPAddress().map({ args0 -> args0 }).orElse(null),
            targetIPAddressType = javaType.targetIPAddressType().map({ args0 -> args0 }).orElse(null),
            targetNicName = javaType.targetNicName().map({ args0 -> args0 }).orElse(null),
            targetSubnetName = javaType.targetSubnetName().map({ args0 -> args0 }).orElse(null),
            testIPAddress = javaType.testIPAddress().map({ args0 -> args0 }).orElse(null),
            testIPAddressType = javaType.testIPAddressType().map({ args0 -> args0 }).orElse(null),
            testNetworkId = javaType.testNetworkId().map({ args0 -> args0 }).orElse(null),
            testSubnetName = javaType.testSubnetName().map({ args0 -> args0 }).orElse(null),
        )
    }
}
