@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * VMwareCbt provider specific container mapping details.
 * @property excludedSkus The SKUs to be excluded.
 * @property instanceType Gets the class type. Overridden in derived classes.
 * Expected value is 'VMwareCbt'.
 * @property keyVaultId The target key vault ARM Id.
 * @property keyVaultUri The target key vault URI.
 * @property roleSizeToNicCountMap The role size to NIC count map.
 * @property serviceBusConnectionStringSecretName The secret name of the service bus connection string.
 * @property storageAccountId The storage account ARM Id.
 * @property storageAccountSasSecretName The secret name of the storage account.
 * @property targetLocation The target location.
 */
public data class VMwareCbtProtectionContainerMappingDetailsResponse(
    public val excludedSkus: List<String>? = null,
    public val instanceType: String,
    public val keyVaultId: String,
    public val keyVaultUri: String,
    public val roleSizeToNicCountMap: Map<String, Int>,
    public val serviceBusConnectionStringSecretName: String,
    public val storageAccountId: String,
    public val storageAccountSasSecretName: String,
    public val targetLocation: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.recoveryservices.outputs.VMwareCbtProtectionContainerMappingDetailsResponse): VMwareCbtProtectionContainerMappingDetailsResponse =
            VMwareCbtProtectionContainerMappingDetailsResponse(
                excludedSkus = javaType.excludedSkus().map({ args0 -> args0 }),
                instanceType = javaType.instanceType(),
                keyVaultId = javaType.keyVaultId(),
                keyVaultUri = javaType.keyVaultUri(),
                roleSizeToNicCountMap = javaType.roleSizeToNicCountMap().map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap(),
                serviceBusConnectionStringSecretName = javaType.serviceBusConnectionStringSecretName(),
                storageAccountId = javaType.storageAccountId(),
                storageAccountSasSecretName = javaType.storageAccountSasSecretName(),
                targetLocation = javaType.targetLocation(),
            )
    }
}
