@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Private Endpoint Connection Response Properties.
 * @property groupIds Group Ids for the Private Endpoint
 * @property privateEndpoint The Private Endpoint network resource that is linked to the Private Endpoint connection.
 * @property privateLinkServiceConnectionState Gets or sets private link service connection state.
 * @property provisioningState Gets or sets provisioning state of the private endpoint connection.
 */
public data class VaultPrivateEndpointConnectionResponse(
    public val groupIds: List<String>? = null,
    public val privateEndpoint: PrivateEndpointResponse,
    public val privateLinkServiceConnectionState: VaultPrivateLinkServiceConnectionStateResponse,
    public val provisioningState: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.recoveryservices.outputs.VaultPrivateEndpointConnectionResponse): VaultPrivateEndpointConnectionResponse = VaultPrivateEndpointConnectionResponse(
            groupIds = javaType.groupIds().map({ args0 -> args0 }),
            privateEndpoint = javaType.privateEndpoint().let({ args0 ->
                com.pulumi.azurenative.recoveryservices.kotlin.outputs.PrivateEndpointResponse.Companion.toKotlin(args0)
            }),
            privateLinkServiceConnectionState = javaType.privateLinkServiceConnectionState().let({ args0 ->
                com.pulumi.azurenative.recoveryservices.kotlin.outputs.VaultPrivateLinkServiceConnectionStateResponse.Companion.toKotlin(args0)
            }),
            provisioningState = javaType.provisioningState(),
        )
    }
}
