@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Properties of the vault.
 * @property backupStorageVersion Backup storage version
 * @property encryption Customer Managed Key details of the resource.
 * @property monitoringSettings Monitoring Settings of the vault
 * @property moveDetails The details of the latest move operation performed on the Azure Resource
 * @property moveState The State of the Resource after the move operation
 * @property privateEndpointConnections List of private endpoint connection.
 * @property privateEndpointStateForBackup Private endpoint state for backup.
 * @property privateEndpointStateForSiteRecovery Private endpoint state for site recovery.
 * @property provisioningState Provisioning State.
 * @property publicNetworkAccess property to enable or disable resource provider inbound network traffic from public clients
 * @property redundancySettings The redundancy Settings of a Vault
 * @property restoreSettings Restore Settings of the vault
 * @property secureScore Secure Score of Recovery Services Vault
 * @property securitySettings Security Settings of the vault
 * @property upgradeDetails Details for upgrading vault.
 */
public data class VaultPropertiesResponse(
    public val backupStorageVersion: String,
    public val encryption: VaultPropertiesResponseEncryption? = null,
    public val monitoringSettings: MonitoringSettingsResponse? = null,
    public val moveDetails: VaultPropertiesResponseMoveDetails? = null,
    public val moveState: String,
    public val privateEndpointConnections: List<PrivateEndpointConnectionVaultPropertiesResponse>,
    public val privateEndpointStateForBackup: String,
    public val privateEndpointStateForSiteRecovery: String,
    public val provisioningState: String,
    public val publicNetworkAccess: String? = null,
    public val redundancySettings: VaultPropertiesResponseRedundancySettings? = null,
    public val restoreSettings: RestoreSettingsResponse? = null,
    public val secureScore: String,
    public val securitySettings: SecuritySettingsResponse? = null,
    public val upgradeDetails: UpgradeDetailsResponse? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.recoveryservices.outputs.VaultPropertiesResponse): VaultPropertiesResponse = VaultPropertiesResponse(
            backupStorageVersion = javaType.backupStorageVersion(),
            encryption = javaType.encryption().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.recoveryservices.kotlin.outputs.VaultPropertiesResponseEncryption.Companion.toKotlin(args0)
                })
            }).orElse(null),
            monitoringSettings = javaType.monitoringSettings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.recoveryservices.kotlin.outputs.MonitoringSettingsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            moveDetails = javaType.moveDetails().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.recoveryservices.kotlin.outputs.VaultPropertiesResponseMoveDetails.Companion.toKotlin(args0)
                })
            }).orElse(null),
            moveState = javaType.moveState(),
            privateEndpointConnections = javaType.privateEndpointConnections().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.recoveryservices.kotlin.outputs.PrivateEndpointConnectionVaultPropertiesResponse.Companion.toKotlin(args0)
                })
            }),
            privateEndpointStateForBackup = javaType.privateEndpointStateForBackup(),
            privateEndpointStateForSiteRecovery = javaType.privateEndpointStateForSiteRecovery(),
            provisioningState = javaType.provisioningState(),
            publicNetworkAccess = javaType.publicNetworkAccess().map({ args0 -> args0 }).orElse(null),
            redundancySettings = javaType.redundancySettings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.recoveryservices.kotlin.outputs.VaultPropertiesResponseRedundancySettings.Companion.toKotlin(args0)
                })
            }).orElse(null),
            restoreSettings = javaType.restoreSettings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.recoveryservices.kotlin.outputs.RestoreSettingsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            secureScore = javaType.secureScore(),
            securitySettings = javaType.securitySettings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.recoveryservices.kotlin.outputs.SecuritySettingsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            upgradeDetails = javaType.upgradeDetails().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.recoveryservices.kotlin.outputs.UpgradeDetailsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
