@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Version related details.
 * @property expiryDate Version expiry date.
 * @property status A value indicating whether security update required.
 * @property version The agent version.
 */
public data class VersionDetailsResponse(
    public val expiryDate: String? = null,
    public val status: String? = null,
    public val version: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.recoveryservices.outputs.VersionDetailsResponse): VersionDetailsResponse = VersionDetailsResponse(
            expiryDate = javaType.expiryDate().map({ args0 -> args0 }).orElse(null),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
            version = javaType.version().map({ args0 -> args0 }).orElse(null),
        )
    }
}
