@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * VMM fabric specific details.
 * @property instanceType Gets the class type. Overridden in derived classes.
 * Expected value is 'VMM'.
 */
public data class VmmDetailsResponse(
    public val instanceType: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.recoveryservices.outputs.VmmDetailsResponse): VmmDetailsResponse = VmmDetailsResponse(
            instanceType = javaType.instanceType(),
        )
    }
}
