@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * E2E Network Mapping fabric specific settings.
 * @property instanceType Gets the Instance type.
 * Expected value is 'VmmToVmm'.
 */
public data class VmmToVmmNetworkMappingSettingsResponse(
    public val instanceType: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.recoveryservices.outputs.VmmToVmmNetworkMappingSettingsResponse): VmmToVmmNetworkMappingSettingsResponse = VmmToVmmNetworkMappingSettingsResponse(
            instanceType = javaType.instanceType(),
        )
    }
}
