@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.outputs

import kotlin.Boolean
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 *
 * @property accessTokenString Access token used for authentication
 * @property bMSActiveRegion Active region name of BMS Stamp
 * @property backupManagementType Backup Management Type
 * @property containerId Container Id
 * @property containerName Container Unique name
 * @property containerType Container Type
 * @property coordinatorServiceStampId CoordinatorServiceStampId to be used by BCM in restore call
 * @property coordinatorServiceStampUri CoordinatorServiceStampUri to be used by BCM in restore call
 * @property datasourceContainerName Datasource Container Unique Name
 * @property datasourceId Datasource Id
 * @property datasourceName Datasource Friendly Name
 * @property datasourceType Datasource Type
 * @property objectType Type of the specific object - used for deserializing
 * Expected value is 'WorkloadCrrAccessToken'.
 * @property policyId Policy Id
 * @property policyName Policy Name
 * @property protectableObjectContainerHostOsName
 * @property protectableObjectFriendlyName
 * @property protectableObjectParentLogicalContainerName
 * @property protectableObjectProtectionState
 * @property protectableObjectUniqueName
 * @property protectableObjectWorkloadType
 * @property protectionContainerId Protected item container id
 * @property protectionServiceStampId ProtectionServiceStampId to be used by BCM in restore call
 * @property protectionServiceStampUri ProtectionServiceStampUri to be used by BCM in restore call
 * @property recoveryPointId Recovery Point Id
 * @property recoveryPointTime Recovery Point Time
 * @property resourceGroupName Resource Group name of the source vault
 * @property resourceId Resource Id of the source vault
 * @property resourceName Resource Name of the source vault
 * @property rpIsManagedVirtualMachine Recovery point information: Managed virtual machine
 * @property rpOriginalSAOption Recovery point information: Original SA option
 * @property rpTierInformation Recovery point Tier Information
 * @property rpVMSizeDescription Recovery point information: VM size description
 * @property subscriptionId Subscription Id of the source vault
 * @property tokenExtendedInformation Extended Information about the token like FileSpec etc.
 */
public data class WorkloadCrrAccessTokenResponse(
    public val accessTokenString: String? = null,
    public val bMSActiveRegion: String? = null,
    public val backupManagementType: String? = null,
    public val containerId: String? = null,
    public val containerName: String? = null,
    public val containerType: String? = null,
    public val coordinatorServiceStampId: String? = null,
    public val coordinatorServiceStampUri: String? = null,
    public val datasourceContainerName: String? = null,
    public val datasourceId: String? = null,
    public val datasourceName: String? = null,
    public val datasourceType: String? = null,
    public val objectType: String,
    public val policyId: String? = null,
    public val policyName: String? = null,
    public val protectableObjectContainerHostOsName: String? = null,
    public val protectableObjectFriendlyName: String? = null,
    public val protectableObjectParentLogicalContainerName: String? = null,
    public val protectableObjectProtectionState: String? = null,
    public val protectableObjectUniqueName: String? = null,
    public val protectableObjectWorkloadType: String? = null,
    public val protectionContainerId: Double? = null,
    public val protectionServiceStampId: String? = null,
    public val protectionServiceStampUri: String? = null,
    public val recoveryPointId: String? = null,
    public val recoveryPointTime: String? = null,
    public val resourceGroupName: String? = null,
    public val resourceId: String? = null,
    public val resourceName: String? = null,
    public val rpIsManagedVirtualMachine: Boolean? = null,
    public val rpOriginalSAOption: Boolean? = null,
    public val rpTierInformation: Map<String, String>? = null,
    public val rpVMSizeDescription: String? = null,
    public val subscriptionId: String? = null,
    public val tokenExtendedInformation: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.recoveryservices.outputs.WorkloadCrrAccessTokenResponse): WorkloadCrrAccessTokenResponse = WorkloadCrrAccessTokenResponse(
            accessTokenString = javaType.accessTokenString().map({ args0 -> args0 }).orElse(null),
            bMSActiveRegion = javaType.bMSActiveRegion().map({ args0 -> args0 }).orElse(null),
            backupManagementType = javaType.backupManagementType().map({ args0 -> args0 }).orElse(null),
            containerId = javaType.containerId().map({ args0 -> args0 }).orElse(null),
            containerName = javaType.containerName().map({ args0 -> args0 }).orElse(null),
            containerType = javaType.containerType().map({ args0 -> args0 }).orElse(null),
            coordinatorServiceStampId = javaType.coordinatorServiceStampId().map({ args0 ->
                args0
            }).orElse(null),
            coordinatorServiceStampUri = javaType.coordinatorServiceStampUri().map({ args0 ->
                args0
            }).orElse(null),
            datasourceContainerName = javaType.datasourceContainerName().map({ args0 -> args0 }).orElse(null),
            datasourceId = javaType.datasourceId().map({ args0 -> args0 }).orElse(null),
            datasourceName = javaType.datasourceName().map({ args0 -> args0 }).orElse(null),
            datasourceType = javaType.datasourceType().map({ args0 -> args0 }).orElse(null),
            objectType = javaType.objectType(),
            policyId = javaType.policyId().map({ args0 -> args0 }).orElse(null),
            policyName = javaType.policyName().map({ args0 -> args0 }).orElse(null),
            protectableObjectContainerHostOsName = javaType.protectableObjectContainerHostOsName().map({ args0 ->
                args0
            }).orElse(null),
            protectableObjectFriendlyName = javaType.protectableObjectFriendlyName().map({ args0 ->
                args0
            }).orElse(null),
            protectableObjectParentLogicalContainerName = javaType.protectableObjectParentLogicalContainerName().map({ args0 ->
                args0
            }).orElse(null),
            protectableObjectProtectionState = javaType.protectableObjectProtectionState().map({ args0 ->
                args0
            }).orElse(null),
            protectableObjectUniqueName = javaType.protectableObjectUniqueName().map({ args0 ->
                args0
            }).orElse(null),
            protectableObjectWorkloadType = javaType.protectableObjectWorkloadType().map({ args0 ->
                args0
            }).orElse(null),
            protectionContainerId = javaType.protectionContainerId().map({ args0 -> args0 }).orElse(null),
            protectionServiceStampId = javaType.protectionServiceStampId().map({ args0 -> args0 }).orElse(null),
            protectionServiceStampUri = javaType.protectionServiceStampUri().map({ args0 ->
                args0
            }).orElse(null),
            recoveryPointId = javaType.recoveryPointId().map({ args0 -> args0 }).orElse(null),
            recoveryPointTime = javaType.recoveryPointTime().map({ args0 -> args0 }).orElse(null),
            resourceGroupName = javaType.resourceGroupName().map({ args0 -> args0 }).orElse(null),
            resourceId = javaType.resourceId().map({ args0 -> args0 }).orElse(null),
            resourceName = javaType.resourceName().map({ args0 -> args0 }).orElse(null),
            rpIsManagedVirtualMachine = javaType.rpIsManagedVirtualMachine().map({ args0 ->
                args0
            }).orElse(null),
            rpOriginalSAOption = javaType.rpOriginalSAOption().map({ args0 -> args0 }).orElse(null),
            rpTierInformation = javaType.rpTierInformation().map({ args0 ->
                args0.key.to(args0.value)
            }).toMap(),
            rpVMSizeDescription = javaType.rpVMSizeDescription().map({ args0 -> args0 }).orElse(null),
            subscriptionId = javaType.subscriptionId().map({ args0 -> args0 }).orElse(null),
            tokenExtendedInformation = javaType.tokenExtendedInformation().map({ args0 -> args0 }).orElse(null),
        )
    }
}
