@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.redhatopenshift.kotlin

import com.pulumi.azurenative.redhatopenshift.RedhatopenshiftFunctions.getMachinePoolPlain
import com.pulumi.azurenative.redhatopenshift.RedhatopenshiftFunctions.getOpenShiftClusterPlain
import com.pulumi.azurenative.redhatopenshift.RedhatopenshiftFunctions.getSecretPlain
import com.pulumi.azurenative.redhatopenshift.RedhatopenshiftFunctions.getSyncIdentityProviderPlain
import com.pulumi.azurenative.redhatopenshift.RedhatopenshiftFunctions.getSyncSetPlain
import com.pulumi.azurenative.redhatopenshift.RedhatopenshiftFunctions.listOpenShiftClusterAdminCredentialsPlain
import com.pulumi.azurenative.redhatopenshift.RedhatopenshiftFunctions.listOpenShiftClusterCredentialsPlain
import com.pulumi.azurenative.redhatopenshift.kotlin.inputs.GetMachinePoolPlainArgs
import com.pulumi.azurenative.redhatopenshift.kotlin.inputs.GetMachinePoolPlainArgsBuilder
import com.pulumi.azurenative.redhatopenshift.kotlin.inputs.GetOpenShiftClusterPlainArgs
import com.pulumi.azurenative.redhatopenshift.kotlin.inputs.GetOpenShiftClusterPlainArgsBuilder
import com.pulumi.azurenative.redhatopenshift.kotlin.inputs.GetSecretPlainArgs
import com.pulumi.azurenative.redhatopenshift.kotlin.inputs.GetSecretPlainArgsBuilder
import com.pulumi.azurenative.redhatopenshift.kotlin.inputs.GetSyncIdentityProviderPlainArgs
import com.pulumi.azurenative.redhatopenshift.kotlin.inputs.GetSyncIdentityProviderPlainArgsBuilder
import com.pulumi.azurenative.redhatopenshift.kotlin.inputs.GetSyncSetPlainArgs
import com.pulumi.azurenative.redhatopenshift.kotlin.inputs.GetSyncSetPlainArgsBuilder
import com.pulumi.azurenative.redhatopenshift.kotlin.inputs.ListOpenShiftClusterAdminCredentialsPlainArgs
import com.pulumi.azurenative.redhatopenshift.kotlin.inputs.ListOpenShiftClusterAdminCredentialsPlainArgsBuilder
import com.pulumi.azurenative.redhatopenshift.kotlin.inputs.ListOpenShiftClusterCredentialsPlainArgs
import com.pulumi.azurenative.redhatopenshift.kotlin.inputs.ListOpenShiftClusterCredentialsPlainArgsBuilder
import com.pulumi.azurenative.redhatopenshift.kotlin.outputs.GetMachinePoolResult
import com.pulumi.azurenative.redhatopenshift.kotlin.outputs.GetOpenShiftClusterResult
import com.pulumi.azurenative.redhatopenshift.kotlin.outputs.GetSecretResult
import com.pulumi.azurenative.redhatopenshift.kotlin.outputs.GetSyncIdentityProviderResult
import com.pulumi.azurenative.redhatopenshift.kotlin.outputs.GetSyncSetResult
import com.pulumi.azurenative.redhatopenshift.kotlin.outputs.ListOpenShiftClusterAdminCredentialsResult
import com.pulumi.azurenative.redhatopenshift.kotlin.outputs.ListOpenShiftClusterCredentialsResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.redhatopenshift.kotlin.outputs.GetMachinePoolResult.Companion.toKotlin as getMachinePoolResultToKotlin
import com.pulumi.azurenative.redhatopenshift.kotlin.outputs.GetOpenShiftClusterResult.Companion.toKotlin as getOpenShiftClusterResultToKotlin
import com.pulumi.azurenative.redhatopenshift.kotlin.outputs.GetSecretResult.Companion.toKotlin as getSecretResultToKotlin
import com.pulumi.azurenative.redhatopenshift.kotlin.outputs.GetSyncIdentityProviderResult.Companion.toKotlin as getSyncIdentityProviderResultToKotlin
import com.pulumi.azurenative.redhatopenshift.kotlin.outputs.GetSyncSetResult.Companion.toKotlin as getSyncSetResultToKotlin
import com.pulumi.azurenative.redhatopenshift.kotlin.outputs.ListOpenShiftClusterAdminCredentialsResult.Companion.toKotlin as listOpenShiftClusterAdminCredentialsResultToKotlin
import com.pulumi.azurenative.redhatopenshift.kotlin.outputs.ListOpenShiftClusterCredentialsResult.Companion.toKotlin as listOpenShiftClusterCredentialsResultToKotlin

public object RedhatopenshiftFunctions {
    /**
     * The operation returns properties of a MachinePool.
     * Azure REST API version: 2022-09-04.
     * Other available API versions: 2023-04-01, 2023-07-01-preview, 2023-09-04, 2023-11-22.
     * @param argument null
     * @return MachinePool represents a MachinePool
     */
    public suspend fun getMachinePool(argument: GetMachinePoolPlainArgs): GetMachinePoolResult =
        getMachinePoolResultToKotlin(getMachinePoolPlain(argument.toJava()).await())

    /**
     * @see [getMachinePool].
     * @param childResourceName The name of the MachinePool resource.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceName The name of the OpenShift cluster resource.
     * @return MachinePool represents a MachinePool
     */
    public suspend fun getMachinePool(
        childResourceName: String,
        resourceGroupName: String,
        resourceName: String,
    ): GetMachinePoolResult {
        val argument = GetMachinePoolPlainArgs(
            childResourceName = childResourceName,
            resourceGroupName = resourceGroupName,
            resourceName = resourceName,
        )
        return getMachinePoolResultToKotlin(getMachinePoolPlain(argument.toJava()).await())
    }

    /**
     * @see [getMachinePool].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;redhatopenshift&#46;kotlin&#46;inputs&#46;GetMachinePoolPlainArgs].
     * @return MachinePool represents a MachinePool
     */
    public suspend fun getMachinePool(argument: suspend GetMachinePoolPlainArgsBuilder.() -> Unit): GetMachinePoolResult {
        val builder = GetMachinePoolPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getMachinePoolResultToKotlin(getMachinePoolPlain(builtArgument.toJava()).await())
    }

    /**
     * The operation returns properties of a OpenShift cluster.
     * Azure REST API version: 2022-09-04.
     * Other available API versions: 2023-04-01, 2023-07-01-preview, 2023-09-04, 2023-11-22.
     * @param argument null
     * @return OpenShiftCluster represents an Azure Red Hat OpenShift cluster.
     */
    public suspend fun getOpenShiftCluster(argument: GetOpenShiftClusterPlainArgs): GetOpenShiftClusterResult =
        getOpenShiftClusterResultToKotlin(getOpenShiftClusterPlain(argument.toJava()).await())

    /**
     * @see [getOpenShiftCluster].
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceName The name of the OpenShift cluster resource.
     * @return OpenShiftCluster represents an Azure Red Hat OpenShift cluster.
     */
    public suspend fun getOpenShiftCluster(resourceGroupName: String, resourceName: String): GetOpenShiftClusterResult {
        val argument = GetOpenShiftClusterPlainArgs(
            resourceGroupName = resourceGroupName,
            resourceName = resourceName,
        )
        return getOpenShiftClusterResultToKotlin(getOpenShiftClusterPlain(argument.toJava()).await())
    }

    /**
     * @see [getOpenShiftCluster].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;redhatopenshift&#46;kotlin&#46;inputs&#46;GetOpenShiftClusterPlainArgs].
     * @return OpenShiftCluster represents an Azure Red Hat OpenShift cluster.
     */
    public suspend fun getOpenShiftCluster(argument: suspend GetOpenShiftClusterPlainArgsBuilder.() -> Unit): GetOpenShiftClusterResult {
        val builder = GetOpenShiftClusterPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getOpenShiftClusterResultToKotlin(getOpenShiftClusterPlain(builtArgument.toJava()).await())
    }

    /**
     * The operation returns properties of a Secret.
     * Azure REST API version: 2022-09-04.
     * Other available API versions: 2023-04-01, 2023-07-01-preview, 2023-09-04, 2023-11-22.
     * @param argument null
     * @return Secret represents a secret.
     */
    public suspend fun getSecret(argument: GetSecretPlainArgs): GetSecretResult =
        getSecretResultToKotlin(getSecretPlain(argument.toJava()).await())

    /**
     * @see [getSecret].
     * @param childResourceName The name of the Secret resource.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceName The name of the OpenShift cluster resource.
     * @return Secret represents a secret.
     */
    public suspend fun getSecret(
        childResourceName: String,
        resourceGroupName: String,
        resourceName: String,
    ): GetSecretResult {
        val argument = GetSecretPlainArgs(
            childResourceName = childResourceName,
            resourceGroupName = resourceGroupName,
            resourceName = resourceName,
        )
        return getSecretResultToKotlin(getSecretPlain(argument.toJava()).await())
    }

    /**
     * @see [getSecret].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;redhatopenshift&#46;kotlin&#46;inputs&#46;GetSecretPlainArgs].
     * @return Secret represents a secret.
     */
    public suspend fun getSecret(argument: suspend GetSecretPlainArgsBuilder.() -> Unit): GetSecretResult {
        val builder = GetSecretPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getSecretResultToKotlin(getSecretPlain(builtArgument.toJava()).await())
    }

    /**
     * The operation returns properties of a SyncIdentityProvider.
     * Azure REST API version: 2022-09-04.
     * Other available API versions: 2023-04-01, 2023-07-01-preview, 2023-09-04, 2023-11-22.
     * @param argument null
     * @return SyncIdentityProvider represents a SyncIdentityProvider
     */
    public suspend fun getSyncIdentityProvider(argument: GetSyncIdentityProviderPlainArgs): GetSyncIdentityProviderResult =
        getSyncIdentityProviderResultToKotlin(getSyncIdentityProviderPlain(argument.toJava()).await())

    /**
     * @see [getSyncIdentityProvider].
     * @param childResourceName The name of the SyncIdentityProvider resource.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceName The name of the OpenShift cluster resource.
     * @return SyncIdentityProvider represents a SyncIdentityProvider
     */
    public suspend fun getSyncIdentityProvider(
        childResourceName: String,
        resourceGroupName: String,
        resourceName: String,
    ): GetSyncIdentityProviderResult {
        val argument = GetSyncIdentityProviderPlainArgs(
            childResourceName = childResourceName,
            resourceGroupName = resourceGroupName,
            resourceName = resourceName,
        )
        return getSyncIdentityProviderResultToKotlin(getSyncIdentityProviderPlain(argument.toJava()).await())
    }

    /**
     * @see [getSyncIdentityProvider].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;redhatopenshift&#46;kotlin&#46;inputs&#46;GetSyncIdentityProviderPlainArgs].
     * @return SyncIdentityProvider represents a SyncIdentityProvider
     */
    public suspend fun getSyncIdentityProvider(argument: suspend GetSyncIdentityProviderPlainArgsBuilder.() -> Unit): GetSyncIdentityProviderResult {
        val builder = GetSyncIdentityProviderPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getSyncIdentityProviderResultToKotlin(getSyncIdentityProviderPlain(builtArgument.toJava()).await())
    }

    /**
     * The operation returns properties of a SyncSet.
     * Azure REST API version: 2022-09-04.
     * Other available API versions: 2023-04-01, 2023-07-01-preview, 2023-09-04, 2023-11-22.
     * @param argument null
     * @return SyncSet represents a SyncSet for an Azure Red Hat OpenShift Cluster.
     */
    public suspend fun getSyncSet(argument: GetSyncSetPlainArgs): GetSyncSetResult =
        getSyncSetResultToKotlin(getSyncSetPlain(argument.toJava()).await())

    /**
     * @see [getSyncSet].
     * @param childResourceName The name of the SyncSet resource.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceName The name of the OpenShift cluster resource.
     * @return SyncSet represents a SyncSet for an Azure Red Hat OpenShift Cluster.
     */
    public suspend fun getSyncSet(
        childResourceName: String,
        resourceGroupName: String,
        resourceName: String,
    ): GetSyncSetResult {
        val argument = GetSyncSetPlainArgs(
            childResourceName = childResourceName,
            resourceGroupName = resourceGroupName,
            resourceName = resourceName,
        )
        return getSyncSetResultToKotlin(getSyncSetPlain(argument.toJava()).await())
    }

    /**
     * @see [getSyncSet].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;redhatopenshift&#46;kotlin&#46;inputs&#46;GetSyncSetPlainArgs].
     * @return SyncSet represents a SyncSet for an Azure Red Hat OpenShift Cluster.
     */
    public suspend fun getSyncSet(argument: suspend GetSyncSetPlainArgsBuilder.() -> Unit): GetSyncSetResult {
        val builder = GetSyncSetPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getSyncSetResultToKotlin(getSyncSetPlain(builtArgument.toJava()).await())
    }

    /**
     * The operation returns the admin kubeconfig.
     * Azure REST API version: 2022-09-04.
     * Other available API versions: 2023-04-01, 2023-07-01-preview, 2023-09-04, 2023-11-22.
     * @param argument null
     * @return OpenShiftClusterAdminKubeconfig represents an OpenShift cluster's admin kubeconfig.
     */
    public suspend fun listOpenShiftClusterAdminCredentials(argument: ListOpenShiftClusterAdminCredentialsPlainArgs): ListOpenShiftClusterAdminCredentialsResult =
        listOpenShiftClusterAdminCredentialsResultToKotlin(listOpenShiftClusterAdminCredentialsPlain(argument.toJava()).await())

    /**
     * @see [listOpenShiftClusterAdminCredentials].
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceName The name of the OpenShift cluster resource.
     * @return OpenShiftClusterAdminKubeconfig represents an OpenShift cluster's admin kubeconfig.
     */
    public suspend fun listOpenShiftClusterAdminCredentials(
        resourceGroupName: String,
        resourceName: String,
    ): ListOpenShiftClusterAdminCredentialsResult {
        val argument = ListOpenShiftClusterAdminCredentialsPlainArgs(
            resourceGroupName = resourceGroupName,
            resourceName = resourceName,
        )
        return listOpenShiftClusterAdminCredentialsResultToKotlin(listOpenShiftClusterAdminCredentialsPlain(argument.toJava()).await())
    }

    /**
     * @see [listOpenShiftClusterAdminCredentials].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;redhatopenshift&#46;kotlin&#46;inputs&#46;ListOpenShiftClusterAdminCredentialsPlainArgs].
     * @return OpenShiftClusterAdminKubeconfig represents an OpenShift cluster's admin kubeconfig.
     */
    public suspend fun listOpenShiftClusterAdminCredentials(argument: suspend ListOpenShiftClusterAdminCredentialsPlainArgsBuilder.() -> Unit): ListOpenShiftClusterAdminCredentialsResult {
        val builder = ListOpenShiftClusterAdminCredentialsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listOpenShiftClusterAdminCredentialsResultToKotlin(listOpenShiftClusterAdminCredentialsPlain(builtArgument.toJava()).await())
    }

    /**
     * The operation returns the credentials.
     * Azure REST API version: 2022-09-04.
     * Other available API versions: 2023-04-01, 2023-07-01-preview, 2023-09-04, 2023-11-22.
     * @param argument null
     * @return OpenShiftClusterCredentials represents an OpenShift cluster's credentials.
     */
    public suspend fun listOpenShiftClusterCredentials(argument: ListOpenShiftClusterCredentialsPlainArgs): ListOpenShiftClusterCredentialsResult =
        listOpenShiftClusterCredentialsResultToKotlin(listOpenShiftClusterCredentialsPlain(argument.toJava()).await())

    /**
     * @see [listOpenShiftClusterCredentials].
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceName The name of the OpenShift cluster resource.
     * @return OpenShiftClusterCredentials represents an OpenShift cluster's credentials.
     */
    public suspend fun listOpenShiftClusterCredentials(
        resourceGroupName: String,
        resourceName: String,
    ): ListOpenShiftClusterCredentialsResult {
        val argument = ListOpenShiftClusterCredentialsPlainArgs(
            resourceGroupName = resourceGroupName,
            resourceName = resourceName,
        )
        return listOpenShiftClusterCredentialsResultToKotlin(listOpenShiftClusterCredentialsPlain(argument.toJava()).await())
    }

    /**
     * @see [listOpenShiftClusterCredentials].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;redhatopenshift&#46;kotlin&#46;inputs&#46;ListOpenShiftClusterCredentialsPlainArgs].
     * @return OpenShiftClusterCredentials represents an OpenShift cluster's credentials.
     */
    public suspend fun listOpenShiftClusterCredentials(argument: suspend ListOpenShiftClusterCredentialsPlainArgsBuilder.() -> Unit): ListOpenShiftClusterCredentialsResult {
        val builder = ListOpenShiftClusterCredentialsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listOpenShiftClusterCredentialsResultToKotlin(listOpenShiftClusterCredentialsPlain(builtArgument.toJava()).await())
    }
}
