@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.redhatopenshift.kotlin.inputs

import com.pulumi.azurenative.redhatopenshift.inputs.NetworkProfileArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * NetworkProfile represents a network profile.
 * @property podCidr The CIDR used for OpenShift/Kubernetes Pods.
 * @property serviceCidr The CIDR used for OpenShift/Kubernetes Services.
 */
public data class NetworkProfileArgs(
    public val podCidr: Output<String>? = null,
    public val serviceCidr: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.redhatopenshift.inputs.NetworkProfileArgs> {
    override fun toJava(): com.pulumi.azurenative.redhatopenshift.inputs.NetworkProfileArgs =
        com.pulumi.azurenative.redhatopenshift.inputs.NetworkProfileArgs.builder()
            .podCidr(podCidr?.applyValue({ args0 -> args0 }))
            .serviceCidr(serviceCidr?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [NetworkProfileArgs].
 */
@PulumiTagMarker
public class NetworkProfileArgsBuilder internal constructor() {
    private var podCidr: Output<String>? = null

    private var serviceCidr: Output<String>? = null

    /**
     * @param value The CIDR used for OpenShift/Kubernetes Pods.
     */
    @JvmName("lnthylsdftibybyc")
    public suspend fun podCidr(`value`: Output<String>) {
        this.podCidr = value
    }

    /**
     * @param value The CIDR used for OpenShift/Kubernetes Services.
     */
    @JvmName("wyfmxxoaeinbxbcs")
    public suspend fun serviceCidr(`value`: Output<String>) {
        this.serviceCidr = value
    }

    /**
     * @param value The CIDR used for OpenShift/Kubernetes Pods.
     */
    @JvmName("glpfbfvhadtqqhmf")
    public suspend fun podCidr(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.podCidr = mapped
    }

    /**
     * @param value The CIDR used for OpenShift/Kubernetes Services.
     */
    @JvmName("qigntfvrrbnkwadl")
    public suspend fun serviceCidr(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceCidr = mapped
    }

    internal fun build(): NetworkProfileArgs = NetworkProfileArgs(
        podCidr = podCidr,
        serviceCidr = serviceCidr,
    )
}
