@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.redhatopenshift.kotlin.inputs

import com.pulumi.azurenative.redhatopenshift.inputs.WorkerProfileArgs.builder
import com.pulumi.azurenative.redhatopenshift.kotlin.enums.EncryptionAtHost
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * WorkerProfile represents a worker profile.
 * @property count The number of worker VMs.
 * @property diskEncryptionSetId The resource ID of an associated DiskEncryptionSet, if applicable.
 * @property diskSizeGB The disk size of the worker VMs.
 * @property encryptionAtHost Whether master virtual machines are encrypted at host.
 * @property name The worker profile name.
 * @property subnetId The Azure resource ID of the worker subnet.
 * @property vmSize The size of the worker VMs.
 */
public data class WorkerProfileArgs(
    public val count: Output<Int>? = null,
    public val diskEncryptionSetId: Output<String>? = null,
    public val diskSizeGB: Output<Int>? = null,
    public val encryptionAtHost: Output<Either<String, EncryptionAtHost>>? = null,
    public val name: Output<String>? = null,
    public val subnetId: Output<String>? = null,
    public val vmSize: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.redhatopenshift.inputs.WorkerProfileArgs> {
    override fun toJava(): com.pulumi.azurenative.redhatopenshift.inputs.WorkerProfileArgs =
        com.pulumi.azurenative.redhatopenshift.inputs.WorkerProfileArgs.builder()
            .count(count?.applyValue({ args0 -> args0 }))
            .diskEncryptionSetId(diskEncryptionSetId?.applyValue({ args0 -> args0 }))
            .diskSizeGB(diskSizeGB?.applyValue({ args0 -> args0 }))
            .encryptionAtHost(
                encryptionAtHost?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .name(name?.applyValue({ args0 -> args0 }))
            .subnetId(subnetId?.applyValue({ args0 -> args0 }))
            .vmSize(vmSize?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [WorkerProfileArgs].
 */
@PulumiTagMarker
public class WorkerProfileArgsBuilder internal constructor() {
    private var count: Output<Int>? = null

    private var diskEncryptionSetId: Output<String>? = null

    private var diskSizeGB: Output<Int>? = null

    private var encryptionAtHost: Output<Either<String, EncryptionAtHost>>? = null

    private var name: Output<String>? = null

    private var subnetId: Output<String>? = null

    private var vmSize: Output<String>? = null

    /**
     * @param value The number of worker VMs.
     */
    @JvmName("hilgwsvcjhdmsugl")
    public suspend fun count(`value`: Output<Int>) {
        this.count = value
    }

    /**
     * @param value The resource ID of an associated DiskEncryptionSet, if applicable.
     */
    @JvmName("mrmcdppaonimjjnc")
    public suspend fun diskEncryptionSetId(`value`: Output<String>) {
        this.diskEncryptionSetId = value
    }

    /**
     * @param value The disk size of the worker VMs.
     */
    @JvmName("ixokeojxwkqotqrx")
    public suspend fun diskSizeGB(`value`: Output<Int>) {
        this.diskSizeGB = value
    }

    /**
     * @param value Whether master virtual machines are encrypted at host.
     */
    @JvmName("rqeqhgqrtmsvlwvx")
    public suspend fun encryptionAtHost(`value`: Output<Either<String, EncryptionAtHost>>) {
        this.encryptionAtHost = value
    }

    /**
     * @param value The worker profile name.
     */
    @JvmName("wxonetqirbxgioak")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The Azure resource ID of the worker subnet.
     */
    @JvmName("wkelgjsutmtmmyks")
    public suspend fun subnetId(`value`: Output<String>) {
        this.subnetId = value
    }

    /**
     * @param value The size of the worker VMs.
     */
    @JvmName("mcvbhnykvliuuxak")
    public suspend fun vmSize(`value`: Output<String>) {
        this.vmSize = value
    }

    /**
     * @param value The number of worker VMs.
     */
    @JvmName("jklkdslppcykovyj")
    public suspend fun count(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.count = mapped
    }

    /**
     * @param value The resource ID of an associated DiskEncryptionSet, if applicable.
     */
    @JvmName("fogkfhwrpkahvfvf")
    public suspend fun diskEncryptionSetId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.diskEncryptionSetId = mapped
    }

    /**
     * @param value The disk size of the worker VMs.
     */
    @JvmName("qsplmvslflwvvmmv")
    public suspend fun diskSizeGB(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.diskSizeGB = mapped
    }

    /**
     * @param value Whether master virtual machines are encrypted at host.
     */
    @JvmName("hwujlbakblfgqsqa")
    public suspend fun encryptionAtHost(`value`: Either<String, EncryptionAtHost>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encryptionAtHost = mapped
    }

    /**
     * @param value Whether master virtual machines are encrypted at host.
     */
    @JvmName("dllofrrcbregcbfs")
    public fun encryptionAtHost(`value`: String) {
        val toBeMapped = Either.ofLeft<String, EncryptionAtHost>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.encryptionAtHost = mapped
    }

    /**
     * @param value Whether master virtual machines are encrypted at host.
     */
    @JvmName("ekqyogmitfvlntwu")
    public fun encryptionAtHost(`value`: EncryptionAtHost) {
        val toBeMapped = Either.ofRight<String, EncryptionAtHost>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.encryptionAtHost = mapped
    }

    /**
     * @param value The worker profile name.
     */
    @JvmName("uedrwwslqbpkjnye")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The Azure resource ID of the worker subnet.
     */
    @JvmName("dcrtchuutxmwufex")
    public suspend fun subnetId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subnetId = mapped
    }

    /**
     * @param value The size of the worker VMs.
     */
    @JvmName("jbntiublftjpwlii")
    public suspend fun vmSize(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vmSize = mapped
    }

    internal fun build(): WorkerProfileArgs = WorkerProfileArgs(
        count = count,
        diskEncryptionSetId = diskEncryptionSetId,
        diskSizeGB = diskSizeGB,
        encryptionAtHost = encryptionAtHost,
        name = name,
        subnetId = subnetId,
        vmSize = vmSize,
    )
}
