@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.redhatopenshift.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * IngressProfile represents an ingress profile.
 * @property ip The IP of the ingress.
 * @property name The ingress profile name.
 * @property visibility Ingress visibility.
 */
public data class IngressProfileResponse(
    public val ip: String? = null,
    public val name: String? = null,
    public val visibility: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.redhatopenshift.outputs.IngressProfileResponse): IngressProfileResponse = IngressProfileResponse(
            ip = javaType.ip().map({ args0 -> args0 }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            visibility = javaType.visibility().map({ args0 -> args0 }).orElse(null),
        )
    }
}
