@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.redhatopenshift.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * MasterProfile represents a master profile.
 * @property diskEncryptionSetId The resource ID of an associated DiskEncryptionSet, if applicable.
 * @property encryptionAtHost Whether master virtual machines are encrypted at host.
 * @property subnetId The Azure resource ID of the master subnet.
 * @property vmSize The size of the master VMs.
 */
public data class MasterProfileResponse(
    public val diskEncryptionSetId: String? = null,
    public val encryptionAtHost: String? = null,
    public val subnetId: String? = null,
    public val vmSize: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.redhatopenshift.outputs.MasterProfileResponse): MasterProfileResponse = MasterProfileResponse(
            diskEncryptionSetId = javaType.diskEncryptionSetId().map({ args0 -> args0 }).orElse(null),
            encryptionAtHost = javaType.encryptionAtHost().map({ args0 -> args0 }).orElse(null),
            subnetId = javaType.subnetId().map({ args0 -> args0 }).orElse(null),
            vmSize = javaType.vmSize().map({ args0 -> args0 }).orElse(null),
        )
    }
}
