@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.redhatopenshift.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * NetworkProfile represents a network profile.
 * @property podCidr The CIDR used for OpenShift/Kubernetes Pods.
 * @property serviceCidr The CIDR used for OpenShift/Kubernetes Services.
 */
public data class NetworkProfileResponse(
    public val podCidr: String? = null,
    public val serviceCidr: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.redhatopenshift.outputs.NetworkProfileResponse): NetworkProfileResponse = NetworkProfileResponse(
            podCidr = javaType.podCidr().map({ args0 -> args0 }).orElse(null),
            serviceCidr = javaType.serviceCidr().map({ args0 -> args0 }).orElse(null),
        )
    }
}
