@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.redhatopenshift.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * ServicePrincipalProfile represents a service principal profile.
 * @property clientId The client ID used for the cluster.
 * @property clientSecret The client secret used for the cluster.
 */
public data class ServicePrincipalProfileResponse(
    public val clientId: String? = null,
    public val clientSecret: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.redhatopenshift.outputs.ServicePrincipalProfileResponse): ServicePrincipalProfileResponse = ServicePrincipalProfileResponse(
            clientId = javaType.clientId().map({ args0 -> args0 }).orElse(null),
            clientSecret = javaType.clientSecret().map({ args0 -> args0 }).orElse(null),
        )
    }
}
