@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.relay.kotlin

import com.pulumi.azurenative.relay.NamespaceAuthorizationRuleArgs.builder
import com.pulumi.azurenative.relay.kotlin.enums.AccessRights
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Single item in a List or Get AuthorizationRule operation
 * Azure REST API version: 2021-11-01. Prior API version in Azure Native 1.x: 2017-04-01.
 * Other available API versions: 2017-04-01.
 * ## Example Usage
 * ### RelayNameSpaceAuthorizationRuleCreate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var namespaceAuthorizationRule = new AzureNative.Relay.NamespaceAuthorizationRule("namespaceAuthorizationRule", new()
 *     {
 *         AuthorizationRuleName = "example-RelayAuthRules-01",
 *         NamespaceName = "example-RelayNamespace-01",
 *         ResourceGroupName = "resourcegroup",
 *         Rights = new[]
 *         {
 *             AzureNative.Relay.AccessRights.Listen,
 *             AzureNative.Relay.AccessRights.Send,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/relay/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := relay.NewNamespaceAuthorizationRule(ctx, "namespaceAuthorizationRule", &relay.NamespaceAuthorizationRuleArgs{
 * 			AuthorizationRuleName: pulumi.String("example-RelayAuthRules-01"),
 * 			NamespaceName:         pulumi.String("example-RelayNamespace-01"),
 * 			ResourceGroupName:     pulumi.String("resourcegroup"),
 * 			Rights: pulumi.StringArray{
 * 				pulumi.String(relay.AccessRightsListen),
 * 				pulumi.String(relay.AccessRightsSend),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.relay.NamespaceAuthorizationRule;
 * import com.pulumi.azurenative.relay.NamespaceAuthorizationRuleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var namespaceAuthorizationRule = new NamespaceAuthorizationRule("namespaceAuthorizationRule", NamespaceAuthorizationRuleArgs.builder()
 *             .authorizationRuleName("example-RelayAuthRules-01")
 *             .namespaceName("example-RelayNamespace-01")
 *             .resourceGroupName("resourcegroup")
 *             .rights(
 *                 "Listen",
 *                 "Send")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:relay:NamespaceAuthorizationRule example-RelayAuthRules-01 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Relay/namespaces/{namespaceName}/authorizationRules/{authorizationRuleName}
 * ```
 * @property authorizationRuleName The authorization rule name.
 * @property namespaceName The namespace name
 * @property resourceGroupName Name of the Resource group within the Azure subscription.
 * @property rights The rights associated with the rule.
 */
public data class NamespaceAuthorizationRuleArgs(
    public val authorizationRuleName: Output<String>? = null,
    public val namespaceName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val rights: Output<List<Either<String, AccessRights>>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.relay.NamespaceAuthorizationRuleArgs> {
    override fun toJava(): com.pulumi.azurenative.relay.NamespaceAuthorizationRuleArgs =
        com.pulumi.azurenative.relay.NamespaceAuthorizationRuleArgs.builder()
            .authorizationRuleName(authorizationRuleName?.applyValue({ args0 -> args0 }))
            .namespaceName(namespaceName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .rights(
                rights?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.transform(
                            { args0 -> args0 },
                            { args0 -> args0.let({ args0 -> args0.toJava() }) },
                        )
                    })
                }),
            ).build()
}

/**
 * Builder for [NamespaceAuthorizationRuleArgs].
 */
@PulumiTagMarker
public class NamespaceAuthorizationRuleArgsBuilder internal constructor() {
    private var authorizationRuleName: Output<String>? = null

    private var namespaceName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var rights: Output<List<Either<String, AccessRights>>>? = null

    /**
     * @param value The authorization rule name.
     */
    @JvmName("hlbnmxehctptkhvq")
    public suspend fun authorizationRuleName(`value`: Output<String>) {
        this.authorizationRuleName = value
    }

    /**
     * @param value The namespace name
     */
    @JvmName("yirojoobqbcrddxn")
    public suspend fun namespaceName(`value`: Output<String>) {
        this.namespaceName = value
    }

    /**
     * @param value Name of the Resource group within the Azure subscription.
     */
    @JvmName("asshhwdcghjcnjny")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The rights associated with the rule.
     */
    @JvmName("sduhnlfqjinadptt")
    public suspend fun rights(`value`: Output<List<Either<String, AccessRights>>>) {
        this.rights = value
    }

    @JvmName("xycewjoqwdtmejdg")
    public suspend fun rights(vararg values: Output<Either<String, AccessRights>>) {
        this.rights = Output.all(values.asList())
    }

    /**
     * @param values The rights associated with the rule.
     */
    @JvmName("hputydymvgjcyess")
    public suspend fun rights(values: List<Output<Either<String, AccessRights>>>) {
        this.rights = Output.all(values)
    }

    /**
     * @param value The authorization rule name.
     */
    @JvmName("vfahgshiyrmiqcwi")
    public suspend fun authorizationRuleName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authorizationRuleName = mapped
    }

    /**
     * @param value The namespace name
     */
    @JvmName("xhftokahwesbfjqw")
    public suspend fun namespaceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.namespaceName = mapped
    }

    /**
     * @param value Name of the Resource group within the Azure subscription.
     */
    @JvmName("jotmidewmhseyckd")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The rights associated with the rule.
     */
    @JvmName("iraigsvdrtigslod")
    public suspend fun rights(`value`: List<Either<String, AccessRights>>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rights = mapped
    }

    /**
     * @param values The rights associated with the rule.
     */
    @JvmName("soctvnlfhomryjdh")
    public suspend fun rights(vararg values: Either<String, AccessRights>) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.rights = mapped
    }

    internal fun build(): NamespaceAuthorizationRuleArgs = NamespaceAuthorizationRuleArgs(
        authorizationRuleName = authorizationRuleName,
        namespaceName = namespaceName,
        resourceGroupName = resourceGroupName,
        rights = rights,
    )
}
