@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.relay.kotlin

import com.pulumi.azurenative.relay.kotlin.outputs.ConnectionStateResponse
import com.pulumi.azurenative.relay.kotlin.outputs.PrivateEndpointResponse
import com.pulumi.azurenative.relay.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.relay.kotlin.outputs.ConnectionStateResponse.Companion.toKotlin as connectionStateResponseToKotlin
import com.pulumi.azurenative.relay.kotlin.outputs.PrivateEndpointResponse.Companion.toKotlin as privateEndpointResponseToKotlin
import com.pulumi.azurenative.relay.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [PrivateEndpointConnection].
 */
@PulumiTagMarker
public class PrivateEndpointConnectionResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: PrivateEndpointConnectionArgs = PrivateEndpointConnectionArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend PrivateEndpointConnectionArgsBuilder.() -> Unit) {
        val builder = PrivateEndpointConnectionArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): PrivateEndpointConnection {
        val builtJavaResource =
            com.pulumi.azurenative.relay.PrivateEndpointConnection(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return PrivateEndpointConnection(builtJavaResource)
    }
}

/**
 * Properties of the PrivateEndpointConnection.
 * Azure REST API version: 2021-11-01. Prior API version in Azure Native 1.x: 2018-01-01-preview.
 * Other available API versions: 2018-01-01-preview.
 * ## Example Usage
 * ### NameSpacePrivateEndPointConnectionCreate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var privateEndpointConnection = new AzureNative.Relay.PrivateEndpointConnection("privateEndpointConnection", new()
 *     {
 *         NamespaceName = "example-RelayNamespace-5849",
 *         PrivateEndpoint = new AzureNative.Relay.Inputs.PrivateEndpointArgs
 *         {
 *             Id = "/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/resourcegroup/providers/Microsoft.Network/privateEndpoints/ali-relay-pve-1",
 *         },
 *         PrivateEndpointConnectionName = "{privateEndpointConnection name}",
 *         PrivateLinkServiceConnectionState = new AzureNative.Relay.Inputs.ConnectionStateArgs
 *         {
 *             Description = "You may pass",
 *             Status = AzureNative.Relay.PrivateLinkConnectionStatus.Approved,
 *         },
 *         ResourceGroupName = "resourcegroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/relay/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := relay.NewPrivateEndpointConnection(ctx, "privateEndpointConnection", &relay.PrivateEndpointConnectionArgs{
 * 			NamespaceName: pulumi.String("example-RelayNamespace-5849"),
 * 			PrivateEndpoint: &relay.PrivateEndpointArgs{
 * 				Id: pulumi.String("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/resourcegroup/providers/Microsoft.Network/privateEndpoints/ali-relay-pve-1"),
 * 			},
 * 			PrivateEndpointConnectionName: pulumi.String("{privateEndpointConnection name}"),
 * 			PrivateLinkServiceConnectionState: &relay.ConnectionStateArgs{
 * 				Description: pulumi.String("You may pass"),
 * 				Status:      pulumi.String(relay.PrivateLinkConnectionStatusApproved),
 * 			},
 * 			ResourceGroupName: pulumi.String("resourcegroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.relay.PrivateEndpointConnection;
 * import com.pulumi.azurenative.relay.PrivateEndpointConnectionArgs;
 * import com.pulumi.azurenative.relay.inputs.PrivateEndpointArgs;
 * import com.pulumi.azurenative.relay.inputs.ConnectionStateArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var privateEndpointConnection = new PrivateEndpointConnection("privateEndpointConnection", PrivateEndpointConnectionArgs.builder()
 *             .namespaceName("example-RelayNamespace-5849")
 *             .privateEndpoint(PrivateEndpointArgs.builder()
 *                 .id("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/resourcegroup/providers/Microsoft.Network/privateEndpoints/ali-relay-pve-1")
 *                 .build())
 *             .privateEndpointConnectionName("{privateEndpointConnection name}")
 *             .privateLinkServiceConnectionState(ConnectionStateArgs.builder()
 *                 .description("You may pass")
 *                 .status("Approved")
 *                 .build())
 *             .resourceGroupName("resourcegroup")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:relay:PrivateEndpointConnection {privateEndpointConnection name} /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Relay/namespaces/{namespaceName}/privateEndpointConnections/{privateEndpointConnectionName}
 * ```
 */
public class PrivateEndpointConnection internal constructor(
    override val javaResource: com.pulumi.azurenative.relay.PrivateEndpointConnection,
) : KotlinCustomResource(javaResource, PrivateEndpointConnectionMapper) {
    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The Private Endpoint resource for this Connection.
     */
    public val privateEndpoint: Output<PrivateEndpointResponse>?
        get() = javaResource.privateEndpoint().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> privateEndpointResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Details about the state of the connection.
     */
    public val privateLinkServiceConnectionState: Output<ConnectionStateResponse>?
        get() = javaResource.privateLinkServiceConnectionState().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    connectionStateResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Provisioning state of the Private Endpoint Connection.
     */
    public val provisioningState: Output<String>?
        get() = javaResource.provisioningState().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The system meta data relating to this resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The type of the resource. E.g. "Microsoft.EventHub/Namespaces" or "Microsoft.EventHub/Namespaces/EventHubs"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object PrivateEndpointConnectionMapper : ResourceMapper<PrivateEndpointConnection> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.relay.PrivateEndpointConnection::class == javaResource::class

    override fun map(javaResource: Resource): PrivateEndpointConnection =
        PrivateEndpointConnection(
            javaResource as
                com.pulumi.azurenative.relay.PrivateEndpointConnection,
        )
}

/**
 * @see [PrivateEndpointConnection].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [PrivateEndpointConnection].
 */
public suspend fun privateEndpointConnection(
    name: String,
    block: suspend PrivateEndpointConnectionResourceBuilder.() -> Unit,
): PrivateEndpointConnection {
    val builder = PrivateEndpointConnectionResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [PrivateEndpointConnection].
 * @param name The _unique_ name of the resulting resource.
 */
public fun privateEndpointConnection(name: String): PrivateEndpointConnection {
    val builder = PrivateEndpointConnectionResourceBuilder()
    builder.name(name)
    return builder.build()
}
