@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.relay.kotlin

import com.pulumi.azurenative.relay.RelayFunctions.getHybridConnectionAuthorizationRulePlain
import com.pulumi.azurenative.relay.RelayFunctions.getHybridConnectionPlain
import com.pulumi.azurenative.relay.RelayFunctions.getNamespaceAuthorizationRulePlain
import com.pulumi.azurenative.relay.RelayFunctions.getNamespacePlain
import com.pulumi.azurenative.relay.RelayFunctions.getPrivateEndpointConnectionPlain
import com.pulumi.azurenative.relay.RelayFunctions.getWCFRelayAuthorizationRulePlain
import com.pulumi.azurenative.relay.RelayFunctions.getWCFRelayPlain
import com.pulumi.azurenative.relay.RelayFunctions.listHybridConnectionKeysPlain
import com.pulumi.azurenative.relay.RelayFunctions.listNamespaceKeysPlain
import com.pulumi.azurenative.relay.RelayFunctions.listWCFRelayKeysPlain
import com.pulumi.azurenative.relay.kotlin.inputs.GetHybridConnectionAuthorizationRulePlainArgs
import com.pulumi.azurenative.relay.kotlin.inputs.GetHybridConnectionAuthorizationRulePlainArgsBuilder
import com.pulumi.azurenative.relay.kotlin.inputs.GetHybridConnectionPlainArgs
import com.pulumi.azurenative.relay.kotlin.inputs.GetHybridConnectionPlainArgsBuilder
import com.pulumi.azurenative.relay.kotlin.inputs.GetNamespaceAuthorizationRulePlainArgs
import com.pulumi.azurenative.relay.kotlin.inputs.GetNamespaceAuthorizationRulePlainArgsBuilder
import com.pulumi.azurenative.relay.kotlin.inputs.GetNamespacePlainArgs
import com.pulumi.azurenative.relay.kotlin.inputs.GetNamespacePlainArgsBuilder
import com.pulumi.azurenative.relay.kotlin.inputs.GetPrivateEndpointConnectionPlainArgs
import com.pulumi.azurenative.relay.kotlin.inputs.GetPrivateEndpointConnectionPlainArgsBuilder
import com.pulumi.azurenative.relay.kotlin.inputs.GetWCFRelayAuthorizationRulePlainArgs
import com.pulumi.azurenative.relay.kotlin.inputs.GetWCFRelayAuthorizationRulePlainArgsBuilder
import com.pulumi.azurenative.relay.kotlin.inputs.GetWCFRelayPlainArgs
import com.pulumi.azurenative.relay.kotlin.inputs.GetWCFRelayPlainArgsBuilder
import com.pulumi.azurenative.relay.kotlin.inputs.ListHybridConnectionKeysPlainArgs
import com.pulumi.azurenative.relay.kotlin.inputs.ListHybridConnectionKeysPlainArgsBuilder
import com.pulumi.azurenative.relay.kotlin.inputs.ListNamespaceKeysPlainArgs
import com.pulumi.azurenative.relay.kotlin.inputs.ListNamespaceKeysPlainArgsBuilder
import com.pulumi.azurenative.relay.kotlin.inputs.ListWCFRelayKeysPlainArgs
import com.pulumi.azurenative.relay.kotlin.inputs.ListWCFRelayKeysPlainArgsBuilder
import com.pulumi.azurenative.relay.kotlin.outputs.GetHybridConnectionAuthorizationRuleResult
import com.pulumi.azurenative.relay.kotlin.outputs.GetHybridConnectionResult
import com.pulumi.azurenative.relay.kotlin.outputs.GetNamespaceAuthorizationRuleResult
import com.pulumi.azurenative.relay.kotlin.outputs.GetNamespaceResult
import com.pulumi.azurenative.relay.kotlin.outputs.GetPrivateEndpointConnectionResult
import com.pulumi.azurenative.relay.kotlin.outputs.GetWCFRelayAuthorizationRuleResult
import com.pulumi.azurenative.relay.kotlin.outputs.GetWCFRelayResult
import com.pulumi.azurenative.relay.kotlin.outputs.ListHybridConnectionKeysResult
import com.pulumi.azurenative.relay.kotlin.outputs.ListNamespaceKeysResult
import com.pulumi.azurenative.relay.kotlin.outputs.ListWCFRelayKeysResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.relay.kotlin.outputs.GetHybridConnectionAuthorizationRuleResult.Companion.toKotlin as getHybridConnectionAuthorizationRuleResultToKotlin
import com.pulumi.azurenative.relay.kotlin.outputs.GetHybridConnectionResult.Companion.toKotlin as getHybridConnectionResultToKotlin
import com.pulumi.azurenative.relay.kotlin.outputs.GetNamespaceAuthorizationRuleResult.Companion.toKotlin as getNamespaceAuthorizationRuleResultToKotlin
import com.pulumi.azurenative.relay.kotlin.outputs.GetNamespaceResult.Companion.toKotlin as getNamespaceResultToKotlin
import com.pulumi.azurenative.relay.kotlin.outputs.GetPrivateEndpointConnectionResult.Companion.toKotlin as getPrivateEndpointConnectionResultToKotlin
import com.pulumi.azurenative.relay.kotlin.outputs.GetWCFRelayAuthorizationRuleResult.Companion.toKotlin as getWCFRelayAuthorizationRuleResultToKotlin
import com.pulumi.azurenative.relay.kotlin.outputs.GetWCFRelayResult.Companion.toKotlin as getWCFRelayResultToKotlin
import com.pulumi.azurenative.relay.kotlin.outputs.ListHybridConnectionKeysResult.Companion.toKotlin as listHybridConnectionKeysResultToKotlin
import com.pulumi.azurenative.relay.kotlin.outputs.ListNamespaceKeysResult.Companion.toKotlin as listNamespaceKeysResultToKotlin
import com.pulumi.azurenative.relay.kotlin.outputs.ListWCFRelayKeysResult.Companion.toKotlin as listWCFRelayKeysResultToKotlin

public object RelayFunctions {
    /**
     * Returns the description for the specified hybrid connection.
     * Azure REST API version: 2021-11-01.
     * @param argument null
     * @return Description of hybrid connection resource.
     */
    public suspend fun getHybridConnection(argument: GetHybridConnectionPlainArgs): GetHybridConnectionResult =
        getHybridConnectionResultToKotlin(getHybridConnectionPlain(argument.toJava()).await())

    /**
     * @see [getHybridConnection].
     * @param hybridConnectionName The hybrid connection name.
     * @param namespaceName The namespace name
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @return Description of hybrid connection resource.
     */
    public suspend fun getHybridConnection(
        hybridConnectionName: String,
        namespaceName: String,
        resourceGroupName: String,
    ): GetHybridConnectionResult {
        val argument = GetHybridConnectionPlainArgs(
            hybridConnectionName = hybridConnectionName,
            namespaceName = namespaceName,
            resourceGroupName = resourceGroupName,
        )
        return getHybridConnectionResultToKotlin(getHybridConnectionPlain(argument.toJava()).await())
    }

    /**
     * @see [getHybridConnection].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;relay&#46;kotlin&#46;inputs&#46;GetHybridConnectionPlainArgs].
     * @return Description of hybrid connection resource.
     */
    public suspend fun getHybridConnection(argument: suspend GetHybridConnectionPlainArgsBuilder.() -> Unit): GetHybridConnectionResult {
        val builder = GetHybridConnectionPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getHybridConnectionResultToKotlin(getHybridConnectionPlain(builtArgument.toJava()).await())
    }

    /**
     * Hybrid connection authorization rule for a hybrid connection by name.
     * Azure REST API version: 2021-11-01.
     * Other available API versions: 2017-04-01.
     * @param argument null
     * @return Single item in a List or Get AuthorizationRule operation
     */
    public suspend fun getHybridConnectionAuthorizationRule(argument: GetHybridConnectionAuthorizationRulePlainArgs): GetHybridConnectionAuthorizationRuleResult =
        getHybridConnectionAuthorizationRuleResultToKotlin(getHybridConnectionAuthorizationRulePlain(argument.toJava()).await())

    /**
     * @see [getHybridConnectionAuthorizationRule].
     * @param authorizationRuleName The authorization rule name.
     * @param hybridConnectionName The hybrid connection name.
     * @param namespaceName The namespace name
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @return Single item in a List or Get AuthorizationRule operation
     */
    public suspend fun getHybridConnectionAuthorizationRule(
        authorizationRuleName: String,
        hybridConnectionName: String,
        namespaceName: String,
        resourceGroupName: String,
    ): GetHybridConnectionAuthorizationRuleResult {
        val argument = GetHybridConnectionAuthorizationRulePlainArgs(
            authorizationRuleName = authorizationRuleName,
            hybridConnectionName = hybridConnectionName,
            namespaceName = namespaceName,
            resourceGroupName = resourceGroupName,
        )
        return getHybridConnectionAuthorizationRuleResultToKotlin(getHybridConnectionAuthorizationRulePlain(argument.toJava()).await())
    }

    /**
     * @see [getHybridConnectionAuthorizationRule].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;relay&#46;kotlin&#46;inputs&#46;GetHybridConnectionAuthorizationRulePlainArgs].
     * @return Single item in a List or Get AuthorizationRule operation
     */
    public suspend fun getHybridConnectionAuthorizationRule(argument: suspend GetHybridConnectionAuthorizationRulePlainArgsBuilder.() -> Unit): GetHybridConnectionAuthorizationRuleResult {
        val builder = GetHybridConnectionAuthorizationRulePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getHybridConnectionAuthorizationRuleResultToKotlin(getHybridConnectionAuthorizationRulePlain(builtArgument.toJava()).await())
    }

    /**
     * Returns the description for the specified namespace.
     * Azure REST API version: 2021-11-01.
     * @param argument null
     * @return Description of a namespace resource.
     */
    public suspend fun getNamespace(argument: GetNamespacePlainArgs): GetNamespaceResult =
        getNamespaceResultToKotlin(getNamespacePlain(argument.toJava()).await())

    /**
     * @see [getNamespace].
     * @param namespaceName The namespace name
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @return Description of a namespace resource.
     */
    public suspend fun getNamespace(namespaceName: String, resourceGroupName: String): GetNamespaceResult {
        val argument = GetNamespacePlainArgs(
            namespaceName = namespaceName,
            resourceGroupName = resourceGroupName,
        )
        return getNamespaceResultToKotlin(getNamespacePlain(argument.toJava()).await())
    }

    /**
     * @see [getNamespace].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;relay&#46;kotlin&#46;inputs&#46;GetNamespacePlainArgs].
     * @return Description of a namespace resource.
     */
    public suspend fun getNamespace(argument: suspend GetNamespacePlainArgsBuilder.() -> Unit): GetNamespaceResult {
        val builder = GetNamespacePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getNamespaceResultToKotlin(getNamespacePlain(builtArgument.toJava()).await())
    }

    /**
     * Authorization rule for a namespace by name.
     * Azure REST API version: 2021-11-01.
     * Other available API versions: 2017-04-01.
     * @param argument null
     * @return Single item in a List or Get AuthorizationRule operation
     */
    public suspend fun getNamespaceAuthorizationRule(argument: GetNamespaceAuthorizationRulePlainArgs): GetNamespaceAuthorizationRuleResult =
        getNamespaceAuthorizationRuleResultToKotlin(getNamespaceAuthorizationRulePlain(argument.toJava()).await())

    /**
     * @see [getNamespaceAuthorizationRule].
     * @param authorizationRuleName The authorization rule name.
     * @param namespaceName The namespace name
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @return Single item in a List or Get AuthorizationRule operation
     */
    public suspend fun getNamespaceAuthorizationRule(
        authorizationRuleName: String,
        namespaceName: String,
        resourceGroupName: String,
    ): GetNamespaceAuthorizationRuleResult {
        val argument = GetNamespaceAuthorizationRulePlainArgs(
            authorizationRuleName = authorizationRuleName,
            namespaceName = namespaceName,
            resourceGroupName = resourceGroupName,
        )
        return getNamespaceAuthorizationRuleResultToKotlin(getNamespaceAuthorizationRulePlain(argument.toJava()).await())
    }

    /**
     * @see [getNamespaceAuthorizationRule].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;relay&#46;kotlin&#46;inputs&#46;GetNamespaceAuthorizationRulePlainArgs].
     * @return Single item in a List or Get AuthorizationRule operation
     */
    public suspend fun getNamespaceAuthorizationRule(argument: suspend GetNamespaceAuthorizationRulePlainArgsBuilder.() -> Unit): GetNamespaceAuthorizationRuleResult {
        val builder = GetNamespaceAuthorizationRulePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getNamespaceAuthorizationRuleResultToKotlin(getNamespaceAuthorizationRulePlain(builtArgument.toJava()).await())
    }

    /**
     * Gets a description for the specified Private Endpoint Connection name.
     * Azure REST API version: 2021-11-01.
     * Other available API versions: 2018-01-01-preview.
     * @param argument null
     * @return Properties of the PrivateEndpointConnection.
     */
    public suspend fun getPrivateEndpointConnection(argument: GetPrivateEndpointConnectionPlainArgs): GetPrivateEndpointConnectionResult =
        getPrivateEndpointConnectionResultToKotlin(getPrivateEndpointConnectionPlain(argument.toJava()).await())

    /**
     * @see [getPrivateEndpointConnection].
     * @param namespaceName The namespace name
     * @param privateEndpointConnectionName The PrivateEndpointConnection name
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @return Properties of the PrivateEndpointConnection.
     */
    public suspend fun getPrivateEndpointConnection(
        namespaceName: String,
        privateEndpointConnectionName: String,
        resourceGroupName: String,
    ): GetPrivateEndpointConnectionResult {
        val argument = GetPrivateEndpointConnectionPlainArgs(
            namespaceName = namespaceName,
            privateEndpointConnectionName = privateEndpointConnectionName,
            resourceGroupName = resourceGroupName,
        )
        return getPrivateEndpointConnectionResultToKotlin(getPrivateEndpointConnectionPlain(argument.toJava()).await())
    }

    /**
     * @see [getPrivateEndpointConnection].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;relay&#46;kotlin&#46;inputs&#46;GetPrivateEndpointConnectionPlainArgs].
     * @return Properties of the PrivateEndpointConnection.
     */
    public suspend fun getPrivateEndpointConnection(argument: suspend GetPrivateEndpointConnectionPlainArgsBuilder.() -> Unit): GetPrivateEndpointConnectionResult {
        val builder = GetPrivateEndpointConnectionPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getPrivateEndpointConnectionResultToKotlin(getPrivateEndpointConnectionPlain(builtArgument.toJava()).await())
    }

    /**
     * Returns the description for the specified WCF relay.
     * Azure REST API version: 2021-11-01.
     * Other available API versions: 2016-07-01.
     * @param argument null
     * @return Description of the WCF relay resource.
     */
    public suspend fun getWCFRelay(argument: GetWCFRelayPlainArgs): GetWCFRelayResult =
        getWCFRelayResultToKotlin(getWCFRelayPlain(argument.toJava()).await())

    /**
     * @see [getWCFRelay].
     * @param namespaceName The namespace name
     * @param relayName The relay name.
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @return Description of the WCF relay resource.
     */
    public suspend fun getWCFRelay(
        namespaceName: String,
        relayName: String,
        resourceGroupName: String,
    ): GetWCFRelayResult {
        val argument = GetWCFRelayPlainArgs(
            namespaceName = namespaceName,
            relayName = relayName,
            resourceGroupName = resourceGroupName,
        )
        return getWCFRelayResultToKotlin(getWCFRelayPlain(argument.toJava()).await())
    }

    /**
     * @see [getWCFRelay].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;relay&#46;kotlin&#46;inputs&#46;GetWCFRelayPlainArgs].
     * @return Description of the WCF relay resource.
     */
    public suspend fun getWCFRelay(argument: suspend GetWCFRelayPlainArgsBuilder.() -> Unit): GetWCFRelayResult {
        val builder = GetWCFRelayPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getWCFRelayResultToKotlin(getWCFRelayPlain(builtArgument.toJava()).await())
    }

    /**
     * Get authorizationRule for a WCF relay by name.
     * Azure REST API version: 2021-11-01.
     * Other available API versions: 2017-04-01.
     * @param argument null
     * @return Single item in a List or Get AuthorizationRule operation
     */
    public suspend fun getWCFRelayAuthorizationRule(argument: GetWCFRelayAuthorizationRulePlainArgs): GetWCFRelayAuthorizationRuleResult =
        getWCFRelayAuthorizationRuleResultToKotlin(getWCFRelayAuthorizationRulePlain(argument.toJava()).await())

    /**
     * @see [getWCFRelayAuthorizationRule].
     * @param authorizationRuleName The authorization rule name.
     * @param namespaceName The namespace name
     * @param relayName The relay name.
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @return Single item in a List or Get AuthorizationRule operation
     */
    public suspend fun getWCFRelayAuthorizationRule(
        authorizationRuleName: String,
        namespaceName: String,
        relayName: String,
        resourceGroupName: String,
    ): GetWCFRelayAuthorizationRuleResult {
        val argument = GetWCFRelayAuthorizationRulePlainArgs(
            authorizationRuleName = authorizationRuleName,
            namespaceName = namespaceName,
            relayName = relayName,
            resourceGroupName = resourceGroupName,
        )
        return getWCFRelayAuthorizationRuleResultToKotlin(getWCFRelayAuthorizationRulePlain(argument.toJava()).await())
    }

    /**
     * @see [getWCFRelayAuthorizationRule].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;relay&#46;kotlin&#46;inputs&#46;GetWCFRelayAuthorizationRulePlainArgs].
     * @return Single item in a List or Get AuthorizationRule operation
     */
    public suspend fun getWCFRelayAuthorizationRule(argument: suspend GetWCFRelayAuthorizationRulePlainArgsBuilder.() -> Unit): GetWCFRelayAuthorizationRuleResult {
        val builder = GetWCFRelayAuthorizationRulePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getWCFRelayAuthorizationRuleResultToKotlin(getWCFRelayAuthorizationRulePlain(builtArgument.toJava()).await())
    }

    /**
     * Primary and secondary connection strings to the hybrid connection.
     * Azure REST API version: 2021-11-01.
     * @param argument null
     * @return Namespace/Relay Connection String
     */
    public suspend fun listHybridConnectionKeys(argument: ListHybridConnectionKeysPlainArgs): ListHybridConnectionKeysResult =
        listHybridConnectionKeysResultToKotlin(listHybridConnectionKeysPlain(argument.toJava()).await())

    /**
     * @see [listHybridConnectionKeys].
     * @param authorizationRuleName The authorization rule name.
     * @param hybridConnectionName The hybrid connection name.
     * @param namespaceName The namespace name
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @return Namespace/Relay Connection String
     */
    public suspend fun listHybridConnectionKeys(
        authorizationRuleName: String,
        hybridConnectionName: String,
        namespaceName: String,
        resourceGroupName: String,
    ): ListHybridConnectionKeysResult {
        val argument = ListHybridConnectionKeysPlainArgs(
            authorizationRuleName = authorizationRuleName,
            hybridConnectionName = hybridConnectionName,
            namespaceName = namespaceName,
            resourceGroupName = resourceGroupName,
        )
        return listHybridConnectionKeysResultToKotlin(listHybridConnectionKeysPlain(argument.toJava()).await())
    }

    /**
     * @see [listHybridConnectionKeys].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;relay&#46;kotlin&#46;inputs&#46;ListHybridConnectionKeysPlainArgs].
     * @return Namespace/Relay Connection String
     */
    public suspend fun listHybridConnectionKeys(argument: suspend ListHybridConnectionKeysPlainArgsBuilder.() -> Unit): ListHybridConnectionKeysResult {
        val builder = ListHybridConnectionKeysPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listHybridConnectionKeysResultToKotlin(listHybridConnectionKeysPlain(builtArgument.toJava()).await())
    }

    /**
     * Primary and secondary connection strings to the namespace.
     * Azure REST API version: 2021-11-01.
     * @param argument null
     * @return Namespace/Relay Connection String
     */
    public suspend fun listNamespaceKeys(argument: ListNamespaceKeysPlainArgs): ListNamespaceKeysResult =
        listNamespaceKeysResultToKotlin(listNamespaceKeysPlain(argument.toJava()).await())

    /**
     * @see [listNamespaceKeys].
     * @param authorizationRuleName The authorization rule name.
     * @param namespaceName The namespace name
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @return Namespace/Relay Connection String
     */
    public suspend fun listNamespaceKeys(
        authorizationRuleName: String,
        namespaceName: String,
        resourceGroupName: String,
    ): ListNamespaceKeysResult {
        val argument = ListNamespaceKeysPlainArgs(
            authorizationRuleName = authorizationRuleName,
            namespaceName = namespaceName,
            resourceGroupName = resourceGroupName,
        )
        return listNamespaceKeysResultToKotlin(listNamespaceKeysPlain(argument.toJava()).await())
    }

    /**
     * @see [listNamespaceKeys].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;relay&#46;kotlin&#46;inputs&#46;ListNamespaceKeysPlainArgs].
     * @return Namespace/Relay Connection String
     */
    public suspend fun listNamespaceKeys(argument: suspend ListNamespaceKeysPlainArgsBuilder.() -> Unit): ListNamespaceKeysResult {
        val builder = ListNamespaceKeysPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listNamespaceKeysResultToKotlin(listNamespaceKeysPlain(builtArgument.toJava()).await())
    }

    /**
     * Primary and secondary connection strings to the WCF relay.
     * Azure REST API version: 2021-11-01.
     * @param argument null
     * @return Namespace/Relay Connection String
     */
    public suspend fun listWCFRelayKeys(argument: ListWCFRelayKeysPlainArgs): ListWCFRelayKeysResult =
        listWCFRelayKeysResultToKotlin(listWCFRelayKeysPlain(argument.toJava()).await())

    /**
     * @see [listWCFRelayKeys].
     * @param authorizationRuleName The authorization rule name.
     * @param namespaceName The namespace name
     * @param relayName The relay name.
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @return Namespace/Relay Connection String
     */
    public suspend fun listWCFRelayKeys(
        authorizationRuleName: String,
        namespaceName: String,
        relayName: String,
        resourceGroupName: String,
    ): ListWCFRelayKeysResult {
        val argument = ListWCFRelayKeysPlainArgs(
            authorizationRuleName = authorizationRuleName,
            namespaceName = namespaceName,
            relayName = relayName,
            resourceGroupName = resourceGroupName,
        )
        return listWCFRelayKeysResultToKotlin(listWCFRelayKeysPlain(argument.toJava()).await())
    }

    /**
     * @see [listWCFRelayKeys].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;relay&#46;kotlin&#46;inputs&#46;ListWCFRelayKeysPlainArgs].
     * @return Namespace/Relay Connection String
     */
    public suspend fun listWCFRelayKeys(argument: suspend ListWCFRelayKeysPlainArgsBuilder.() -> Unit): ListWCFRelayKeysResult {
        val builder = ListWCFRelayKeysPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listWCFRelayKeysResultToKotlin(listWCFRelayKeysPlain(builtArgument.toJava()).await())
    }
}
