@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.relay.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Single item in a List or Get AuthorizationRule operation
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property location The geo-location where the resource lives
 * @property name The name of the resource
 * @property rights The rights associated with the rule.
 * @property systemData The system meta data relating to this resource.
 * @property type The type of the resource. E.g. "Microsoft.EventHub/Namespaces" or "Microsoft.EventHub/Namespaces/EventHubs"
 */
public data class GetHybridConnectionAuthorizationRuleResult(
    public val id: String,
    public val location: String,
    public val name: String,
    public val rights: List<String>,
    public val systemData: SystemDataResponse,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.relay.outputs.GetHybridConnectionAuthorizationRuleResult): GetHybridConnectionAuthorizationRuleResult = GetHybridConnectionAuthorizationRuleResult(
            id = javaType.id(),
            location = javaType.location(),
            name = javaType.name(),
            rights = javaType.rights().map({ args0 -> args0 }),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.relay.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
        )
    }
}
